/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.partition.impl.PartitionDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.MigrationState;
import com.hazelcast.partition.ReplicaMigrationEvent;
import java.io.IOException;

public class ReplicaMigrationEventImpl
implements ReplicaMigrationEvent,
IdentifiedDataSerializable {
    private MigrationState state;
    private int partitionId;
    private int replicaIndex;
    private Member source;
    private Member destination;
    private boolean success;
    private long elapsedTime;

    public ReplicaMigrationEventImpl() {
    }

    public ReplicaMigrationEventImpl(MigrationState state, int partitionId, int replicaIndex, Member source2, Member destination, boolean success, long elapsedTime) {
        this.state = state;
        this.partitionId = partitionId;
        this.replicaIndex = replicaIndex;
        this.source = source2;
        this.destination = destination;
        this.success = success;
        this.elapsedTime = elapsedTime;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    @Override
    public Member getSource() {
        return this.source;
    }

    @Override
    public Member getDestination() {
        return this.destination;
    }

    @Override
    public MigrationState getMigrationState() {
        return this.state;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.state);
        out.writeInt(this.partitionId);
        out.writeInt(this.replicaIndex);
        out.writeObject(this.source);
        out.writeObject(this.destination);
        out.writeBoolean(this.success);
        out.writeLong(this.elapsedTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.state = (MigrationState)in.readObject();
        this.partitionId = in.readInt();
        this.replicaIndex = in.readInt();
        this.source = (Member)in.readObject();
        this.destination = (Member)in.readObject();
        this.success = in.readBoolean();
        this.elapsedTime = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 22;
    }

    public String toString() {
        return "MigrationEvent{state=" + this.state + ", partitionId=" + this.partitionId + ", replicaIndex=" + this.replicaIndex + ", source=" + this.source + ", destination=" + this.destination + ", success=" + this.success + ", elapsedTime=" + this.elapsedTime + "ms}";
    }
}

