/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.nearcache.NearCacheStats;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class NearCacheStatsImpl
implements NearCacheStats {
    private static final double PERCENTAGE = 100.0;
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> OWNED_ENTRY_COUNT = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "ownedEntryCount");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> OWNED_ENTRY_MEMORY_COST = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "ownedEntryMemoryCost");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> HITS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "hits");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> MISSES = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "misses");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> EVICTIONS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "evictions");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> EXPIRATIONS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "expirations");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> INVALIDATIONS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "invalidations");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> INVALIDATION_REQUESTS = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "invalidationRequests");
    private static final AtomicLongFieldUpdater<NearCacheStatsImpl> PERSISTENCE_COUNT = AtomicLongFieldUpdater.newUpdater(NearCacheStatsImpl.class, "persistenceCount");
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    private final long creationTime;
    @Probe(name="ownedEntryCount")
    private volatile long ownedEntryCount;
    @Probe(name="ownedEntryMemoryCost", unit=ProbeUnit.BYTES)
    private volatile long ownedEntryMemoryCost;
    @Probe(name="hits")
    private volatile long hits;
    @Probe(name="misses")
    private volatile long misses;
    @Probe(name="evictions")
    private volatile long evictions;
    @Probe(name="expirations")
    private volatile long expirations;
    @Probe(name="invalidations")
    private volatile long invalidations;
    @Probe(name="invalidationRequests")
    private volatile long invalidationRequests;
    @Probe(name="persistenceCount")
    private volatile long persistenceCount;
    @Probe(name="lastPersistenceTime", unit=ProbeUnit.MS)
    private volatile long lastPersistenceTime;
    @Probe(name="lastPersistenceDuration", unit=ProbeUnit.MS)
    private volatile long lastPersistenceDuration;
    @Probe(name="lastPersistenceWrittenBytes", unit=ProbeUnit.BYTES)
    private volatile long lastPersistenceWrittenBytes;
    @Probe(name="lastPersistenceKeyCount")
    private volatile long lastPersistenceKeyCount;
    private volatile String lastPersistenceFailure = "";

    public NearCacheStatsImpl() {
        this.creationTime = NearCacheStatsImpl.getNowInMillis();
    }

    public NearCacheStatsImpl(NearCacheStats nearCacheStats) {
        NearCacheStatsImpl stats = (NearCacheStatsImpl)nearCacheStats;
        this.creationTime = stats.creationTime;
        this.ownedEntryCount = stats.ownedEntryCount;
        this.ownedEntryMemoryCost = stats.ownedEntryMemoryCost;
        this.hits = stats.hits;
        this.misses = stats.misses;
        this.evictions = stats.evictions;
        this.expirations = stats.expirations;
        this.invalidations = stats.invalidations;
        this.invalidationRequests = stats.invalidationRequests;
        this.persistenceCount = stats.persistenceCount;
        this.lastPersistenceTime = stats.lastPersistenceTime;
        this.lastPersistenceDuration = stats.lastPersistenceDuration;
        this.lastPersistenceWrittenBytes = stats.lastPersistenceWrittenBytes;
        this.lastPersistenceKeyCount = stats.lastPersistenceKeyCount;
        this.lastPersistenceFailure = stats.lastPersistenceFailure;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        OWNED_ENTRY_COUNT.set(this, ownedEntryCount);
    }

    public void incrementOwnedEntryCount() {
        OWNED_ENTRY_COUNT.incrementAndGet(this);
    }

    public void decrementOwnedEntryCount() {
        OWNED_ENTRY_COUNT.decrementAndGet(this);
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.set(this, ownedEntryMemoryCost);
    }

    public void incrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.addAndGet(this, ownedEntryMemoryCost);
    }

    public void decrementOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        OWNED_ENTRY_MEMORY_COST.addAndGet(this, -ownedEntryMemoryCost);
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    void setHits(long hits) {
        HITS.set(this, hits);
    }

    public void incrementHits() {
        HITS.incrementAndGet(this);
    }

    @Override
    public long getMisses() {
        return this.misses;
    }

    void setMisses(long misses) {
        MISSES.set(this, misses);
    }

    public void incrementMisses() {
        MISSES.incrementAndGet(this);
    }

    @Override
    public double getRatio() {
        if (this.misses == 0L) {
            if (this.hits == 0L) {
                return Double.NaN;
            }
            return Double.POSITIVE_INFINITY;
        }
        return (double)this.hits / (double)this.misses * 100.0;
    }

    @Override
    public long getEvictions() {
        return this.evictions;
    }

    public void incrementEvictions() {
        EVICTIONS.incrementAndGet(this);
    }

    @Override
    public long getExpirations() {
        return this.expirations;
    }

    public void incrementExpirations() {
        EXPIRATIONS.incrementAndGet(this);
    }

    @Override
    public long getInvalidations() {
        return this.invalidations;
    }

    public void incrementInvalidations() {
        INVALIDATIONS.incrementAndGet(this);
    }

    public void incrementInvalidations(long delta) {
        INVALIDATIONS.addAndGet(this, delta);
    }

    public long getInvalidationRequests() {
        return this.invalidationRequests;
    }

    public void incrementInvalidationRequests() {
        INVALIDATION_REQUESTS.incrementAndGet(this);
    }

    public void resetInvalidationEvents() {
        INVALIDATION_REQUESTS.set(this, 0L);
    }

    @Override
    public long getPersistenceCount() {
        return this.persistenceCount;
    }

    public void addPersistence(long duration, int writtenBytes, int keyCount) {
        PERSISTENCE_COUNT.incrementAndGet(this);
        this.lastPersistenceTime = NearCacheStatsImpl.getNowInMillis();
        this.lastPersistenceDuration = duration;
        this.lastPersistenceWrittenBytes = writtenBytes;
        this.lastPersistenceKeyCount = keyCount;
        this.lastPersistenceFailure = "";
    }

    public void addPersistenceFailure(Throwable t2) {
        PERSISTENCE_COUNT.incrementAndGet(this);
        this.lastPersistenceTime = NearCacheStatsImpl.getNowInMillis();
        this.lastPersistenceDuration = 0L;
        this.lastPersistenceWrittenBytes = 0L;
        this.lastPersistenceKeyCount = 0L;
        this.lastPersistenceFailure = t2.getClass().getSimpleName() + ": " + t2.getMessage();
    }

    private static long getNowInMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long getLastPersistenceTime() {
        return this.lastPersistenceTime;
    }

    @Override
    public long getLastPersistenceDuration() {
        return this.lastPersistenceDuration;
    }

    @Override
    public long getLastPersistenceWrittenBytes() {
        return this.lastPersistenceWrittenBytes;
    }

    @Override
    public long getLastPersistenceKeyCount() {
        return this.lastPersistenceKeyCount;
    }

    @Override
    public String getLastPersistenceFailure() {
        return this.lastPersistenceFailure;
    }

    public String toString() {
        return "NearCacheStatsImpl{ownedEntryCount=" + this.ownedEntryCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", creationTime=" + this.creationTime + ", hits=" + this.hits + ", misses=" + this.misses + ", ratio=" + String.format("%.1f%%", this.getRatio()) + ", evictions=" + this.evictions + ", expirations=" + this.expirations + ", invalidations=" + this.invalidations + ", invalidationRequests=" + this.invalidationRequests + ", lastPersistenceTime=" + this.lastPersistenceTime + ", persistenceCount=" + this.persistenceCount + ", lastPersistenceDuration=" + this.lastPersistenceDuration + ", lastPersistenceWrittenBytes=" + this.lastPersistenceWrittenBytes + ", lastPersistenceKeyCount=" + this.lastPersistenceKeyCount + ", lastPersistenceFailure='" + this.lastPersistenceFailure + "'" + '}';
    }
}

