/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.operation;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.internal.management.operation.AbstractManagementOperation;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import java.io.IOException;
import java.util.concurrent.Future;

public class ChangeClusterStateOperation
extends AbstractManagementOperation
implements AllowedDuringPassiveState {
    private ClusterState newState;

    public ChangeClusterStateOperation() {
    }

    public ChangeClusterStateOperation(ClusterState newState) {
        this.newState = newState;
    }

    @Override
    public void run() {
        ILogger logger2 = this.getNodeEngine().getLogger(this.getClass());
        ExecutionService executionService = this.getNodeEngine().getExecutionService();
        Future<Void> future = executionService.submit("hz:async", () -> {
            this.getNodeEngine().getClusterService().changeClusterState(this.newState);
            return null;
        });
        executionService.asCompletableFuture(future).whenCompleteAsync(ExceptionUtil.withTryCatch(logger2, (empty, error) -> this.sendResponse(error != null ? ExceptionUtil.peel(error) : null)), ConcurrencyUtil.CALLER_RUNS);
    }

    @Override
    public final Object getResponse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.newState);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.newState = (ClusterState)((Object)in.readObject());
    }

    @Override
    public int getClassId() {
        return 3;
    }
}

