/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.locksupport.operations;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.locksupport.LockStoreImpl;
import com.hazelcast.internal.locksupport.operations.UnlockOperation;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.SplitBrainProtectionCheckAwareOperation;
import java.io.IOException;

public final class UnlockIfLeaseExpiredOperation
extends UnlockOperation
implements SplitBrainProtectionCheckAwareOperation {
    private int version;

    public UnlockIfLeaseExpiredOperation() {
    }

    public UnlockIfLeaseExpiredOperation(ObjectNamespace namespace, Data key, int version) {
        super(namespace, key, -1L, true);
        this.version = version;
    }

    @Override
    public void run() {
        LockStoreImpl lockStore = this.getLockStore();
        int lockVersion = lockStore.getVersion(this.key);
        ILogger logger2 = this.getLogger();
        if (this.version == lockVersion) {
            if (logger2.isFinestEnabled()) {
                logger2.finest("Releasing a lock owned by " + lockStore.getOwnerInfo(this.key) + " after lease timeout!");
            }
            this.forceUnlock();
        } else if (logger2.isFinestEnabled()) {
            logger2.finest("Won't unlock since lock version is not matching expiration version: " + lockVersion + " vs " + this.version);
        }
    }

    @Override
    public boolean shouldBackup() {
        IPartition partition;
        NodeEngine nodeEngine = this.getNodeEngine();
        IPartitionService partitionService = nodeEngine.getPartitionService();
        Address thisAddress = nodeEngine.getThisAddress();
        if (!thisAddress.equals((partition = partitionService.getPartition(this.getPartitionId())).getOwnerOrNull())) {
            return false;
        }
        return super.shouldBackup();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.version);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.version = in.readInt();
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public boolean shouldCheckSplitBrainProtection() {
        return false;
    }
}

