/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientDeployClassesCodec;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.EmptyStatement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClientUserCodeDeploymentService {
    private static final Pattern CLASS_PATTERN = Pattern.compile("(.*)\\.class$");
    private final ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig;
    private final ClassLoader configClassLoader;
    private final List<Map.Entry<String, byte[]>> classDefinitionList = new ArrayList<Map.Entry<String, byte[]>>();

    public ClientUserCodeDeploymentService(ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig, ClassLoader configClassLoader) {
        this.clientUserCodeDeploymentConfig = clientUserCodeDeploymentConfig;
        this.configClassLoader = configClassLoader != null ? configClassLoader : Thread.currentThread().getContextClassLoader();
    }

    public void start() throws IOException, ClassNotFoundException {
        if (!this.clientUserCodeDeploymentConfig.isEnabled()) {
            return;
        }
        this.loadClassesFromJars();
        this.loadClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClasses() throws ClassNotFoundException {
        for (String className : this.clientUserCodeDeploymentConfig.getClassNames()) {
            String resource = className.replace('.', '/').concat(".class");
            InputStream is = null;
            try {
                is = this.configClassLoader.getResourceAsStream(resource);
                if (is == null) {
                    throw new ClassNotFoundException(resource);
                }
                byte[] bytes = IOUtil.toByteArray(is);
                this.classDefinitionList.add(new AbstractMap.SimpleEntry<String, byte[]>(className, bytes));
            }
            catch (IOException e) {
                try {
                    EmptyStatement.ignore(e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(is);
                    throw throwable;
                }
                IOUtil.closeResource(is);
                continue;
            }
            IOUtil.closeResource(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClassesFromJars() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            for (String jarPath : this.clientUserCodeDeploymentConfig.getJarPaths()) {
                this.loadClassesFromJar(os, jarPath);
            }
        }
        finally {
            IOUtil.closeResource(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClassesFromJar(ByteArrayOutputStream os, String jarPath) throws IOException {
        JarInputStream inputStream2 = null;
        try {
            JarEntry entry;
            inputStream2 = this.getJarInputStream(jarPath);
            while ((entry = inputStream2.getNextJarEntry()) != null) {
                String className = this.extractClassName(entry);
                if (className == null) continue;
                byte[] classDefinition = this.readClassDefinition(inputStream2, os);
                inputStream2.closeEntry();
                this.classDefinitionList.add(new AbstractMap.SimpleEntry<String, byte[]>(className, classDefinition));
            }
        }
        finally {
            IOUtil.closeResource(inputStream2);
        }
    }

    private JarInputStream getJarInputStream(String jarPath) throws IOException {
        File file = new File(jarPath);
        if (file.exists()) {
            return new JarInputStream(new FileInputStream(file));
        }
        try {
            URL url = new URL(jarPath);
            return new JarInputStream(url.openStream());
        }
        catch (MalformedURLException e) {
            EmptyStatement.ignore(e);
            InputStream inputStream2 = this.configClassLoader.getResourceAsStream(jarPath);
            if (inputStream2 == null) {
                throw new FileNotFoundException("File could not be found in " + jarPath + "  and resources/" + jarPath);
            }
            return new JarInputStream(inputStream2);
        }
    }

    private byte[] readClassDefinition(JarInputStream inputStream2, ByteArrayOutputStream os) throws IOException {
        int v;
        os.reset();
        while ((v = inputStream2.read()) != -1) {
            os.write(v);
        }
        return os.toByteArray();
    }

    private String extractClassName(JarEntry entry) {
        String entryName = entry.getName();
        Matcher matcher = CLASS_PATTERN.matcher(entryName.replace('/', '.'));
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public void deploy(HazelcastClientInstanceImpl client) throws ExecutionException, InterruptedException {
        if (!this.clientUserCodeDeploymentConfig.isEnabled() || this.classDefinitionList.isEmpty()) {
            return;
        }
        ClientMessage request = ClientDeployClassesCodec.encodeRequest(this.classDefinitionList);
        ClientInvocation invocation = new ClientInvocation(client, request, null);
        ClientInvocationFuture future = invocation.invokeUrgent();
        future.get();
    }

    public List<Map.Entry<String, byte[]>> getClassDefinitionList() {
        return this.classDefinitionList;
    }
}

