/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.topic.ReliableMessageListener;
import com.hazelcast.topic.impl.reliable.MessageRunner;
import com.hazelcast.topic.impl.reliable.ReliableTopicMessage;
import com.hazelcast.version.MemberVersion;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;

public class ClientReliableMessageRunner<E>
extends MessageRunner<E> {
    ClientReliableMessageRunner(UUID id, ReliableMessageListener<E> listener, Ringbuffer<ReliableTopicMessage> ringbuffer, String topicName, int batchSze, SerializationService serializationService, Executor executor, ConcurrentMap<UUID, MessageRunner<E>> runnersMap, ILogger logger2) {
        super(id, listener, ringbuffer, topicName, batchSze, serializationService, executor, runnersMap, logger2);
    }

    @Override
    protected Member getMember(ReliableTopicMessage m4) {
        MemberImpl member = null;
        if (m4.getPublisherAddress() != null) {
            member = new MemberImpl(m4.getPublisherAddress(), MemberVersion.UNKNOWN, false);
        }
        return member;
    }

    @Override
    protected boolean handleInternalException(Throwable t2) {
        if (t2 instanceof HazelcastClientNotActiveException) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Terminating MessageListener " + this.listener + " on topic: " + this.topicName + ".  Reason: HazelcastClient is shutting down");
            }
            return false;
        }
        if (t2 instanceof HazelcastClientOfflineException) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("MessageListener " + this.listener + " on topic: " + this.topicName + " got exception: " + t2 + ". Continuing from last known sequence: " + this.sequence);
            }
            return true;
        }
        return super.handleInternalException(t2);
    }

    @Override
    protected Throwable adjustThrowable(Throwable t2) {
        return ExceptionUtil.peel(t2);
    }
}

