/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.custom.DiskTierConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MemoryTierConfigCodec;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.config.TieredStoreConfig;

public final class TieredStoreConfigCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 1;

    private TieredStoreConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, TieredStoreConfig tieredStoreConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[1]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, tieredStoreConfig.isEnabled());
        clientMessage.add(initialFrame);
        MemoryTierConfigCodec.encode(clientMessage, tieredStoreConfig.getMemoryTierConfig());
        DiskTierConfigCodec.encode(clientMessage, tieredStoreConfig.getDiskTierConfig());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static TieredStoreConfig decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        MemoryTierConfig memoryTierConfig = MemoryTierConfigCodec.decode(iterator2);
        DiskTierConfig diskTierConfig = DiskTierConfigCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createTieredStoreConfig(enabled, memoryTierConfig, diskTierConfig);
    }
}

