/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.config.DataPersistenceConfig;

public final class DataPersistenceConfigCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int FSYNC_FIELD_OFFSET = 1;
    private static final int INITIAL_FRAME_SIZE = 2;

    private DataPersistenceConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, DataPersistenceConfig dataPersistenceConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[2]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, dataPersistenceConfig.isEnabled());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 1, dataPersistenceConfig.isFsync());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static DataPersistenceConfig decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        boolean fsync = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 1);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createDataPersistenceConfig(enabled, fsync);
    }
}

