/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MigrationStateCodec;
import com.hazelcast.internal.partition.MigrationStateImpl;
import com.hazelcast.logging.Logger;
import com.hazelcast.partition.MigrationState;
import java.util.UUID;
import javax.annotation.Nullable;

public final class ClientAddMigrationListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 4352;
    public static final int RESPONSE_MESSAGE_TYPE = 4353;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;
    private static final int EVENT_MIGRATION_TYPE_FIELD_OFFSET = 16;
    private static final int EVENT_MIGRATION_INITIAL_FRAME_SIZE = 20;
    private static final int EVENT_MIGRATION_MESSAGE_TYPE = 4354;
    private static final int EVENT_REPLICA_MIGRATION_PARTITION_ID_FIELD_OFFSET = 16;
    private static final int EVENT_REPLICA_MIGRATION_REPLICA_INDEX_FIELD_OFFSET = 20;
    private static final int EVENT_REPLICA_MIGRATION_SOURCE_UUID_FIELD_OFFSET = 24;
    private static final int EVENT_REPLICA_MIGRATION_DEST_UUID_FIELD_OFFSET = 41;
    private static final int EVENT_REPLICA_MIGRATION_SUCCESS_FIELD_OFFSET = 58;
    private static final int EVENT_REPLICA_MIGRATION_ELAPSED_TIME_FIELD_OFFSET = 59;
    private static final int EVENT_REPLICA_MIGRATION_INITIAL_FRAME_SIZE = 67;
    private static final int EVENT_REPLICA_MIGRATION_MESSAGE_TYPE = 4355;

    private ClientAddMigrationListenerCodec() {
    }

    public static ClientMessage encodeRequest(boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Client.AddMigrationListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 4352);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, localOnly);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static boolean decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator2.next();
        return FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 4353);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static UUID decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator2.next();
        return FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
    }

    public static ClientMessage encodeMigrationEvent(MigrationState migrationState, int type) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 4354);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, type);
        clientMessage.add(initialFrame);
        MigrationStateCodec.encode(clientMessage, migrationState);
        return clientMessage;
    }

    public static ClientMessage encodeReplicaMigrationEvent(MigrationState migrationState, int partitionId, int replicaIndex, @Nullable UUID sourceUuid, @Nullable UUID destUuid, boolean success, long elapsedTime) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[67], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 4355);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, partitionId);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, replicaIndex);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 24, sourceUuid);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 41, destUuid);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 58, success);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 59, elapsedTime);
        clientMessage.add(initialFrame);
        MigrationStateCodec.encode(clientMessage, migrationState);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
            if (messageType == 4354) {
                ClientMessage.Frame initialFrame = iterator2.next();
                int type = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                MigrationStateImpl migrationState = MigrationStateCodec.decode(iterator2);
                this.handleMigrationEvent(migrationState, type);
                return;
            }
            if (messageType == 4355) {
                ClientMessage.Frame initialFrame = iterator2.next();
                int partitionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                int replicaIndex = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
                UUID sourceUuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 24);
                UUID destUuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 41);
                boolean success = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 58);
                long elapsedTime = FixedSizeTypesCodec.decodeLong(initialFrame.content, 59);
                MigrationStateImpl migrationState = MigrationStateCodec.decode(iterator2);
                this.handleReplicaMigrationEvent(migrationState, partitionId, replicaIndex, sourceUuid, destUuid, success, elapsedTime);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleMigrationEvent(MigrationState var1, int var2);

        public abstract void handleReplicaMigrationEvent(MigrationState var1, int var2, int var3, @Nullable UUID var4, @Nullable UUID var5, boolean var6, long var7);
    }
}

