/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Bits;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.ProtectedWrappedChannel;
import org.xnio.channels.ReadListenerSettable;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class FixedLengthStreamSourceChannel
implements StreamSourceChannel,
ProtectedWrappedChannel<StreamSourceChannel>,
ReadListenerSettable<FixedLengthStreamSourceChannel>,
CloseListenerSettable<FixedLengthStreamSourceChannel> {
    private final StreamSourceChannel delegate;
    private final Object guard;
    private final ChannelListener<? super FixedLengthStreamSourceChannel> finishListener;
    private ChannelListener<? super FixedLengthStreamSourceChannel> readListener;
    private ChannelListener<? super FixedLengthStreamSourceChannel> closeListener;
    private int state;
    private long remaining;
    private static final int FLAG_CLOSED = 1;
    private static final int FLAG_FINISHED = 2;
    private static final int FLAG_CONFIGURABLE = 4;
    private static final int FLAG_PASS_CLOSE = 8;

    public FixedLengthStreamSourceChannel(StreamSourceChannel delegate, long contentLength, ChannelListener<? super FixedLengthStreamSourceChannel> finishListener, Object guard) {
        this(delegate, contentLength, false, finishListener, guard);
    }

    public FixedLengthStreamSourceChannel(StreamSourceChannel delegate, long contentLength, boolean configurable, ChannelListener<? super FixedLengthStreamSourceChannel> finishListener, Object guard) {
        this(delegate, contentLength, configurable, false, finishListener, guard);
    }

    public FixedLengthStreamSourceChannel(StreamSourceChannel delegate, long contentLength, boolean configurable, boolean propagateClose, ChannelListener<? super FixedLengthStreamSourceChannel> finishListener, Object guard) {
        this.guard = guard;
        this.finishListener = finishListener;
        if (contentLength < 0L) {
            throw Messages.msg.parameterOutOfRange("contentLength");
        }
        this.delegate = delegate;
        this.remaining = contentLength;
        delegate.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

            @Override
            public void handleEvent(StreamSourceChannel channel) {
                ChannelListeners.invokeChannelListener(FixedLengthStreamSourceChannel.this, FixedLengthStreamSourceChannel.this.readListener);
            }
        });
        this.state = (configurable ? 4 : 0) | (propagateClose ? 8 : 0);
    }

    @Override
    public void setReadListener(ChannelListener<? super FixedLengthStreamSourceChannel> readListener) {
        this.readListener = readListener;
    }

    @Override
    public ChannelListener<? super FixedLengthStreamSourceChannel> getReadListener() {
        return this.readListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super FixedLengthStreamSourceChannel> closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    public ChannelListener<? super FixedLengthStreamSourceChannel> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<FixedLengthStreamSourceChannel> getReadSetter() {
        return new ReadListenerSettable.Setter<FixedLengthStreamSourceChannel>(this);
    }

    public ChannelListener.Setter<FixedLengthStreamSourceChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<FixedLengthStreamSourceChannel>(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long remaining = this.remaining;
        if (Bits.anyAreSet(this.state, 3) || remaining == 0L || count == 0L) {
            return 0L;
        }
        long res = 0L;
        try {
            long l = res = this.delegate.transferTo(position, Math.min(count, remaining), target);
            return l;
        }
        finally {
            if (res > 0L && (this.remaining = remaining - res) == 0L) {
                this.state |= 2;
                this.callFinish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long remaining = this.remaining;
        if (Bits.anyAreSet(this.state, 3) || remaining == 0L) {
            return -1L;
        }
        if (count == 0L) {
            return 0L;
        }
        long res = 0L;
        try {
            long l = res = this.delegate.transferTo(Math.min(count, remaining), throughBuffer, target);
            return l;
        }
        finally {
            if (res > 0L && (this.remaining = remaining - res) == 0L) {
                this.state |= 2;
                this.callFinish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        int lim;
        ByteBuffer buffer;
        long remaining = this.remaining;
        if (Bits.anyAreSet(this.state, 3) || remaining == 0L) {
            return -1L;
        }
        if (length == 0) {
            return 0L;
        }
        if (length == 1) {
            return this.read(dsts[offset]);
        }
        long res = 0L;
        long t2 = 0L;
        for (int i = 0; i < length; ++i) {
            buffer = dsts[i + offset];
            lim = buffer.limit();
            if ((t2 += (long)(lim - buffer.position())) <= remaining) continue;
            buffer.limit(lim - (int)(t2 - remaining));
            long l = res = this.delegate.read(dsts, offset, i + 1);
            return l;
        }
        res = t2 == 0L ? 0L : this.delegate.read(dsts, offset, length);
        long l = res;
        return l;
        {
            finally {
                buffer.limit(lim);
            }
        }
        finally {
            if (res > 0L && (this.remaining = remaining - res) == 0L) {
                this.state |= 2;
                this.callFinish();
            }
        }
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        long remaining = this.remaining;
        if (Bits.anyAreSet(this.state, 3) || remaining == 0L) {
            return -1;
        }
        int res = 0;
        try {
            int lim = dst.limit();
            int pos = dst.position();
            if ((long)(lim - pos) > remaining) {
                dst.limit((int)(remaining - (long)pos));
                int n = res = this.delegate.read(dst);
                return n;
            }
            int n = res = this.delegate.read(dst);
            return n;
            finally {
                dst.limit(lim);
            }
        }
        finally {
            if (res > 0 && (this.remaining = remaining - (long)res) == 0L) {
                this.state |= 2;
                this.callFinish();
            }
        }
    }

    @Override
    public void suspendReads() {
        if (Bits.allAreClear(this.state, 3)) {
            this.delegate.suspendReads();
        }
    }

    @Override
    public void resumeReads() {
        if (Bits.allAreClear(this.state, 3)) {
            this.delegate.resumeReads();
        } else {
            this.delegate.getIoThread().execute(ChannelListeners.getChannelListenerTask(this, this.readListener));
        }
    }

    @Override
    public boolean isReadResumed() {
        return Bits.allAreClear(this.state, 3) && this.delegate.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        if (Bits.allAreClear(this.state, 3)) {
            this.delegate.wakeupReads();
        } else {
            this.delegate.getIoThread().execute(ChannelListeners.getChannelListenerTask(this, this.readListener));
        }
    }

    @Override
    public void shutdownReads() throws IOException {
        int state = this.state;
        if (Bits.allAreClear(state, 1)) {
            try {
                this.state = state | 1 | 2;
                if (Bits.allAreSet(state, 8)) {
                    this.delegate.shutdownReads();
                }
            }
            finally {
                if (Bits.allAreClear(state, 2)) {
                    this.callFinish();
                }
                this.callClosed();
            }
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        if (Bits.anyAreSet(this.state, 3)) {
            return;
        }
        this.delegate.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        if (Bits.anyAreSet(this.state, 3)) {
            return;
        }
        this.delegate.awaitReadable(time, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.delegate.getReadThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public boolean isOpen() {
        return Bits.allAreClear(this.state, 1);
    }

    @Override
    public void close() throws IOException {
        this.shutdownReads();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return Bits.allAreSet(this.state, 4) && this.delegate.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return Bits.allAreSet(this.state, 4) ? (T)this.delegate.getOption(option) : null;
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return Bits.allAreSet(this.state, 4) ? (T)this.delegate.setOption(option, value) : null;
    }

    @Override
    public StreamSourceChannel getChannel(Object guard) {
        Object ourGuard = this.guard;
        if (ourGuard == null || guard == ourGuard) {
            return this.delegate;
        }
        return null;
    }

    public long getRemaining() {
        return this.remaining;
    }

    private void callFinish() {
        ChannelListeners.invokeChannelListener(this, this.finishListener);
    }

    private void callClosed() {
        ChannelListeners.invokeChannelListener(this, this.closeListener);
    }
}

