/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.logstash.logback.composite.AbstractJsonProvider;
import net.logstash.logback.marker.LogstashMarker;
import net.logstash.logback.util.LogbackUtils;
import org.slf4j.Marker;

public class LogstashMarkersJsonProvider
extends AbstractJsonProvider<ILoggingEvent> {
    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        if (LogbackUtils.isVersion13()) {
            this.writeLogstashMarkerIfNecessary(generator, event.getMarkerList());
        } else {
            this.writeLogstashMarkerIfNecessary(generator, event.getMarker());
        }
    }

    private void writeLogstashMarkerIfNecessary(JsonGenerator generator, List<Marker> markers) throws IOException {
        if (markers != null) {
            for (Marker marker : markers) {
                this.writeLogstashMarkerIfNecessary(generator, marker);
            }
        }
    }

    private void writeLogstashMarkerIfNecessary(JsonGenerator generator, Marker marker) throws IOException {
        if (marker != null) {
            if (LogstashMarkersJsonProvider.isLogstashMarker(marker)) {
                ((LogstashMarker)marker).writeTo(generator);
            }
            if (marker.hasReferences()) {
                Iterator<Marker> i = marker.iterator();
                while (i.hasNext()) {
                    Marker next = i.next();
                    this.writeLogstashMarkerIfNecessary(generator, next);
                }
            }
        }
    }

    public static boolean isLogstashMarker(Marker marker) {
        return marker instanceof LogstashMarker;
    }
}

