/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.handler.config.EndpointSource;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.Server;
import com.networknt.openapi.OpenApiHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiEndpointSource
implements EndpointSource {
    private static final Logger log = LoggerFactory.getLogger(OpenApiEndpointSource.class);
    private OpenApiHelper helper;

    public OpenApiEndpointSource(OpenApiHelper helper) {
        this.helper = helper;
    }

    @Override
    public Iterable<EndpointSource.Endpoint> listEndpoints() {
        ArrayList<EndpointSource.Endpoint> endpoints = new ArrayList<EndpointSource.Endpoint>();
        String basePath = this.findBasePath();
        Map<String, Path> paths = this.helper.openApi3.getPaths();
        if (log.isInfoEnabled()) {
            log.info("Generating paths from OpenApi spec");
        }
        for (Map.Entry<String, Path> pathPair : paths.entrySet()) {
            String path = pathPair.getKey();
            for (String method : pathPair.getValue().getOperations().keySet()) {
                EndpointSource.Endpoint endpoint = new EndpointSource.Endpoint(basePath + path, method);
                if (log.isDebugEnabled()) {
                    log.debug(endpoint.toString());
                }
                endpoints.add(endpoint);
            }
        }
        return endpoints;
    }

    public String findBasePath() {
        List<Server> servers = this.helper.openApi3.getServers();
        if (servers.isEmpty()) {
            log.warn("No server found in OpenApi spec. Using empty base path for API.");
            return "";
        }
        Server server = servers.get(0);
        String url = null;
        try {
            url = server.getUrl();
            URL urlObj = new URL(url);
            String basePath = urlObj.getPath();
            while (basePath.endsWith("/")) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            return basePath;
        }
        catch (Exception e) {
            throw new RuntimeException("Malformed servers[0].url in OpenApi spec: " + url, e);
        }
    }
}

