/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.consul.client;

import com.networknt.client.Http2Client;
import com.networknt.config.Config;
import com.networknt.consul.ConsulConfig;
import com.networknt.consul.ConsulResponse;
import com.networknt.consul.ConsulService;
import com.networknt.consul.ConsulUtils;
import com.networknt.consul.client.ConsulClient;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.utility.StringUtils;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class ConsulClientImpl
implements ConsulClient {
    private static final Logger logger = LoggerFactory.getLogger(ConsulClientImpl.class);
    private static final ConsulConfig config = (ConsulConfig)Config.getInstance().getJsonObjectConfig("consul", ConsulConfig.class);
    private static final int UNUSUAL_STATUS_CODE = 300;
    private final Http2Client client = Http2Client.getInstance();
    private final OptionMap optionMap;
    private final URI uri;
    private String wait = "600s";
    private String timeoutBuffer = "5s";

    public ConsulClientImpl() {
        String consulUrl = config.getConsulUrl().toLowerCase();
        OptionMap optionMap = this.optionMap = this.isHttp2() ? OptionMap.create(UndertowOptions.ENABLE_HTTP2, true) : OptionMap.EMPTY;
        if (logger.isDebugEnabled()) {
            logger.debug("consulUrl = {}", (Object)consulUrl);
        }
        if (config.getWait() != null && config.getWait().length() > 2) {
            this.wait = config.getWait();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("wait = {}", (Object)this.wait);
        }
        if (config.getTimeoutBuffer() != null) {
            this.timeoutBuffer = config.getTimeoutBuffer();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("timeoutBuffer = {}", (Object)this.timeoutBuffer);
        }
        try {
            this.uri = new URI(consulUrl);
        }
        catch (URISyntaxException e) {
            logger.error("Invalid URI " + consulUrl, e);
            throw new RuntimeException("Invalid URI " + consulUrl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPass(String serviceId, String token) {
        logger.trace("checkPass serviceId = {}", (Object)serviceId);
        String path = "/v1/agent/check/pass/check-" + serviceId;
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(config.getConnectionTimeout(), this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap);
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to checkPass on Consul: {} : {}", (Object)statusCode, (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
                throw new Exception("Failed to checkPass on Consul: " + statusCode + ":" + reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("CheckPass request exception", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFail(String serviceId, String token) {
        logger.trace("checkFail serviceId = {}", (Object)serviceId);
        String path = "/v1/agent/check/fail/check-" + serviceId;
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(config.getConnectionTimeout(), this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap);
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to checkFail on Consul: {} : {}", (Object)statusCode, (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("CheckFail request exception", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
    }

    @Override
    public void registerService(ConsulService service, String token) {
        String json = service.toString();
        String path = "/v1/agent/service/register";
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(config.getConnectionTimeout(), this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap);
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, json);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                throw new Exception("Failed to register on Consul: " + statusCode);
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            try {
                logger.error("Failed to register on Consul, Exception:", e);
                throw new RuntimeException(e.getMessage());
            }
            catch (Throwable throwable) {
                this.client.returnConnection(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(String serviceId, String token) {
        String path = "/v1/agent/service/deregister/" + serviceId;
        ClientConnection connection = null;
        try {
            connection = this.client.borrowConnection(config.getConnectionTimeout(), this.uri, Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, this.optionMap);
            AtomicReference<ClientResponse> reference = this.send(connection, Methods.PUT, path, token, null);
            int statusCode = reference.get().getResponseCode();
            if (statusCode >= 300) {
                logger.error("Failed to unregister on Consul, body = {}", (Object)reference.get().getAttachment(Http2Client.RESPONSE_BODY));
            }
            this.client.returnConnection(connection);
        }
        catch (Exception e) {
            logger.error("Failed to unregister on Consul, Exception:", e);
        }
        finally {
            this.client.returnConnection(connection);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ConsulResponse<List<ConsulService>> lookupHealthService(String serviceName, String tag, long lastConsulIndex, String token) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ConsulService convertToConsulService(Map<String, Object> serviceMap) {
        ConsulService service = new ConsulService();
        service.setAddress((String)serviceMap.get("Address"));
        service.setId((String)serviceMap.get("ID"));
        service.setName((String)serviceMap.get("Service"));
        service.setPort((Integer)serviceMap.get("Port"));
        service.setTags((List)serviceMap.get("Tags"));
        return service;
    }

    AtomicReference<ClientResponse> send(ClientConnection connection, HttpString method, String path, String token, String json) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
        ClientRequest request = new ClientRequest().setMethod(method).setPath(path);
        request.getRequestHeaders().put(Headers.HOST, "localhost");
        if (token != null) {
            request.getRequestHeaders().put(HttpStringConstants.CONSUL_TOKEN, token);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("The request sent to Consul URI {} - request header: {}, request body is empty", (Object)this.uri.toString(), (Object)request.toString());
        }
        if (StringUtils.isBlank(json)) {
            connection.sendRequest(request, this.client.createClientCallback(reference, latch));
        } else {
            request.getRequestHeaders().put(Headers.TRANSFER_ENCODING, "chunked");
            connection.sendRequest(request, this.client.createClientCallback(reference, latch, json));
        }
        int waitInSecond = ConsulUtils.getWaitInSecond(this.wait);
        int timeoutBufferInSecond = ConsulUtils.getTimeoutBufferInSecond(this.timeoutBuffer);
        boolean isNotTimeout = latch.await(waitInSecond + timeoutBufferInSecond, TimeUnit.SECONDS);
        if (!isNotTimeout) {
            if (connection != null && connection.isOpen()) {
                IoUtils.safeClose((Closeable)connection);
            }
            throw new RuntimeException(String.format("The request to Consul timed out after %d + %d seconds to: %s", waitInSecond, timeoutBufferInSecond, this.uri));
        }
        logger.debug("The response from Consul: {} = {}", (Object)this.uri, (Object)(reference != null ? reference.get() : null));
        return reference;
    }

    private boolean isHttp2() {
        return config.isEnableHttp2() || config.getConsulUrl().toLowerCase().startsWith("https");
    }

    private static class ConsulRequestException
    extends RuntimeException {
        public ConsulRequestException(String message) {
            super(message);
        }
    }
}

