/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.TokenRequest;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLBearerRequest
extends TokenRequest {
    static final String CLIENT_ASSERTION_TYPE_KEY = "client_assertion_type";
    static final String CLIENT_ASSERTION_TYPE_VALUE = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    static final String CLIENT_ASSERTION_KEY = "client_assertion";
    static final String ASSERTION_KEY = "assertion";
    static final String GRANT_TYPE_KEY = "grant_type";
    static final String GRANT_TYPE_VALUE = "urn:ietf:params:oauth:grant-type:saml2-bearer";
    private String samlAssertion;
    private String jwtClientAssertion;
    private static final Logger logger = LoggerFactory.getLogger(SAMLBearerRequest.class);

    public SAMLBearerRequest(String samlAssertion, String jwtClientAssertion) {
        this.setGrantType("saml_bearer");
        this.samlAssertion = samlAssertion;
        this.jwtClientAssertion = jwtClientAssertion;
        try {
            Map<String, Object> tokenConfig = ClientConfig.get().getTokenConfig();
            this.setServerUrl((String)tokenConfig.get("server_url"));
            this.setProxyHost((String)tokenConfig.get("proxyHost"));
            int port = tokenConfig.get("proxyPort") == null ? 443 : (Integer)tokenConfig.get("proxyPort");
            this.setProxyPort(port);
            Object object = tokenConfig.get("enableHttp2");
            this.setEnableHttp2(object != null && (Boolean)object != false);
            Map ccConfig = (Map)tokenConfig.get("client_credentials");
            this.setClientId((String)ccConfig.get("client_id"));
            this.setUri((String)ccConfig.get("uri"));
        }
        catch (NullPointerException e) {
            logger.error("Nullpointer in config object: " + e);
        }
    }

    public String getSamlAssertion() {
        return this.samlAssertion;
    }

    public String getJwtClientAssertion() {
        return this.jwtClientAssertion;
    }
}

