/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.networknt.client.ClientConfig;
import com.networknt.client.Http2Client;
import com.networknt.client.oauth.AuthorizationCodeRequest;
import com.networknt.client.oauth.ClientAuthenticatedUserRequest;
import com.networknt.client.oauth.ClientCredentialsRequest;
import com.networknt.client.oauth.ClientRequestComposerProvider;
import com.networknt.client.oauth.DerefRequest;
import com.networknt.client.oauth.IClientRequestComposable;
import com.networknt.client.oauth.IntrospectionRequest;
import com.networknt.client.oauth.Jwt;
import com.networknt.client.oauth.KeyRequest;
import com.networknt.client.oauth.RefreshTokenRequest;
import com.networknt.client.oauth.SAMLBearerRequest;
import com.networknt.client.oauth.SignRequest;
import com.networknt.client.oauth.TokenRequest;
import com.networknt.client.oauth.TokenResponse;
import com.networknt.cluster.Cluster;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.exception.ClientException;
import com.networknt.httpstring.ContentType;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthHelper {
    private static final String BASIC = "Basic";
    private static final String GRANT_TYPE = "grant_type";
    private static final String CODE = "code";
    private static final String USER_ID = "userId";
    private static final String USER_TYPE = "userType";
    private static final String ROLES = "roles";
    private static final String FAIL_TO_SEND_REQUEST = "ERR10051";
    private static final String GET_TOKEN_ERROR = "ERR10052";
    private static final String ESTABLISH_CONNECTION_ERROR = "ERR10053";
    private static final String GET_TOKEN_TIMEOUT = "ERR10054";
    private static final String TLS_TRUSTSTORE_ERROR = "ERR10055";
    private static final String OAUTH_SERVER_URL_ERROR = "ERR10056";
    public static final String STATUS_CLIENT_CREDENTIALS_TOKEN_NOT_AVAILABLE = "ERR10009";
    private static final Logger logger = LoggerFactory.getLogger(OauthHelper.class);
    private static HttpClient tokenClient = null;
    private static HttpClient introspectionClient = null;
    private static HttpClient signClient = null;
    private static HttpClient derefClient = null;

    public static Result<TokenResponse> getTokenResult(TokenRequest tokenRequest) {
        return OauthHelper.getTokenResult(tokenRequest, null);
    }

    public static Result<TokenResponse> getTokenResult(TokenRequest tokenRequest, String envTag) {
        if (logger.isTraceEnabled()) {
            logger.trace("tokenRequest = " + JsonMapper.toJson(tokenRequest));
        }
        if (tokenClient == null) {
            try {
                Map tlsMap;
                HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(ClientConfig.get().getTimeout())).sslContext(Http2Client.createSSLContext());
                if (logger.isTraceEnabled()) {
                    logger.trace("proxyHost = " + tokenRequest.getProxyHost() + " proxyPort = " + tokenRequest.getProxyPort());
                }
                if (!StringUtils.isBlank(tokenRequest.getProxyHost())) {
                    clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(tokenRequest.getProxyHost(), tokenRequest.getProxyPort() == 0 ? 443 : tokenRequest.getProxyPort())));
                }
                if (tokenRequest.isEnableHttp2()) {
                    clientBuilder.version(HttpClient.Version.HTTP_2);
                }
                if ((tlsMap = (Map)ClientConfig.get().getMappedConfig().get("tls")) != null && !Boolean.TRUE.equals(tlsMap.get("verifyHostname"))) {
                    Properties props = System.getProperties();
                    props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
                }
                tokenClient = clientBuilder.build();
            }
            catch (IOException e) {
                logger.error("Cannot create HttpClient:", e);
                return Failure.of(new Status(TLS_TRUSTSTORE_ERROR, new Object[0]));
            }
        }
        try {
            String serverUrl = tokenRequest.getServerUrl();
            if (serverUrl == null) {
                Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
                tokenRequest.setServerUrl(cluster.serviceToUrl("https", tokenRequest.getServiceId(), envTag, null));
                if (logger.isTraceEnabled()) {
                    logger.trace("serviceUrl is null, discovered url = " + tokenRequest.getServerUrl());
                }
            }
            if (tokenRequest.getServerUrl() == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("serviceUrl is empty and could not discovery serviceUrl. tokenRequest = " + JsonMapper.toJson(tokenRequest));
                }
                return Failure.of(new Status(OAUTH_SERVER_URL_ERROR, "token"));
            }
            if (logger.isTraceEnabled()) {
                logger.trace("token service url = " + serverUrl);
            }
            IClientRequestComposable requestComposer = ClientRequestComposerProvider.getInstance().getComposer(ClientRequestComposerProvider.ClientRequestComposers.CLIENT_CREDENTIAL_REQUEST_COMPOSER);
            HttpRequest request = requestComposer.composeClientRequest(tokenRequest);
            CompletableFuture<HttpResponse<String>> response = tokenClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            String body = (String)((CompletableFuture)response.thenApply(HttpResponse::body)).get();
            HttpHeaders headers = (HttpHeaders)((CompletableFuture)response.thenApply(HttpResponse::headers)).get();
            return OauthHelper.handleResponse(OauthHelper.getContentTypeHeaders(headers), body);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return Failure.of(new Status(ESTABLISH_CONNECTION_ERROR, tokenRequest.getServerUrl()));
        }
    }

    public static Result<TokenResponse> getSignResult(SignRequest signRequest) {
        return OauthHelper.getSignResult(signRequest, null);
    }

    public static Result<TokenResponse> getSignResult(SignRequest signRequest, String envTag) {
        if (signClient == null) {
            try {
                Map tlsMap;
                HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(ClientConfig.get().getTimeout())).sslContext(Http2Client.createSSLContext());
                if (signRequest.getProxyHost() != null) {
                    clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(signRequest.getProxyHost(), signRequest.getProxyPort() == 0 ? 443 : signRequest.getProxyPort())));
                }
                if (signRequest.isEnableHttp2()) {
                    clientBuilder.version(HttpClient.Version.HTTP_2);
                }
                if ((tlsMap = (Map)ClientConfig.get().getMappedConfig().get("tls")) != null && !Boolean.TRUE.equals(tlsMap.get("verifyHostname"))) {
                    Properties props = System.getProperties();
                    props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
                }
                signClient = clientBuilder.build();
            }
            catch (IOException e) {
                logger.error("Cannot create HttpClient:", e);
                return Failure.of(new Status(TLS_TRUSTSTORE_ERROR, new Object[0]));
            }
        }
        try {
            String serverUrl = signRequest.getServerUrl();
            if (serverUrl == null) {
                Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
                signRequest.setServerUrl(cluster.serviceToUrl("https", signRequest.getServiceId(), envTag, null));
            }
            if (signRequest.getServerUrl() == null) {
                return Failure.of(new Status(OAUTH_SERVER_URL_ERROR, "sign"));
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expires", signRequest.getExpires());
            map.put("payload", signRequest.getPayload());
            String requestBody = Config.getInstance().getMapper().writeValueAsString(map);
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(requestBody)).uri(URI.create(signRequest.getServerUrl() + signRequest.getUri()));
            if (signRequest.getClientId() != null && signRequest.getClientSecret() != null) {
                requestBuilder.setHeader("Authorization", OauthHelper.getBasicAuthHeader(signRequest.getClientId(), signRequest.getClientSecret()));
            }
            requestBuilder.setHeader("Content-Type", "application/json");
            HttpRequest request = requestBuilder.build();
            CompletableFuture<HttpResponse<String>> response = signClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            String body = (String)((CompletableFuture)response.thenApply(HttpResponse::body)).get();
            HttpHeaders headers = (HttpHeaders)((CompletableFuture)response.thenApply(HttpResponse::headers)).get();
            return OauthHelper.handleResponse(OauthHelper.getContentTypeHeaders(headers), body);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            return Failure.of(new Status(ESTABLISH_CONNECTION_ERROR, signRequest.getServerUrl()));
        }
    }

    public static Result<TokenResponse> getTokenFromSamlResult(SAMLBearerRequest tokenRequest) {
        return OauthHelper.getTokenResult(tokenRequest, null);
    }

    public static Result<TokenResponse> getTokenFromSamlResult(SAMLBearerRequest tokenRequest, String envTag) {
        if (tokenClient == null) {
            try {
                Map tlsMap;
                HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(ClientConfig.get().getTimeout())).sslContext(Http2Client.createSSLContext());
                if (tokenRequest.getProxyHost() != null) {
                    clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(tokenRequest.getProxyHost(), tokenRequest.getProxyPort() == 0 ? 443 : tokenRequest.getProxyPort())));
                }
                if (tokenRequest.isEnableHttp2()) {
                    clientBuilder.version(HttpClient.Version.HTTP_2);
                }
                if ((tlsMap = (Map)ClientConfig.get().getMappedConfig().get("tls")) != null && !Boolean.TRUE.equals(tlsMap.get("verifyHostname"))) {
                    Properties props = System.getProperties();
                    props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
                }
                tokenClient = clientBuilder.build();
            }
            catch (IOException e) {
                logger.error("Cannot create HttpClient:", e);
                return Failure.of(new Status(TLS_TRUSTSTORE_ERROR, new Object[0]));
            }
        }
        try {
            String serverUrl = tokenRequest.getServerUrl();
            if (serverUrl == null) {
                Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
                tokenRequest.setServerUrl(cluster.serviceToUrl("https", tokenRequest.getServiceId(), envTag, null));
            }
            if (tokenRequest.getServerUrl() == null) {
                return Failure.of(new Status(OAUTH_SERVER_URL_ERROR, "token"));
            }
            IClientRequestComposable requestComposer = ClientRequestComposerProvider.getInstance().getComposer(ClientRequestComposerProvider.ClientRequestComposers.SAML_BEARER_REQUEST_COMPOSER);
            HttpRequest request = requestComposer.composeClientRequest(tokenRequest);
            CompletableFuture<HttpResponse<String>> response = tokenClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            String body = (String)((CompletableFuture)response.thenApply(HttpResponse::body)).get();
            HttpHeaders headers = (HttpHeaders)((CompletableFuture)response.thenApply(HttpResponse::headers)).get();
            return OauthHelper.handleResponse(OauthHelper.getContentTypeHeaders(headers), body);
        }
        catch (Exception e) {
            logger.error("IOException: ", e);
            return Failure.of(new Status(ESTABLISH_CONNECTION_ERROR, tokenRequest.getServerUrl()));
        }
    }

    public static String getKey(KeyRequest keyRequest) throws ClientException {
        if (logger.isDebugEnabled()) {
            logger.debug("keyRequest = " + keyRequest.toString());
        }
        return OauthHelper.getKey(keyRequest, null);
    }

    public static Result<String> getIntrospection(String token, IntrospectionRequest introspectionRequest) throws ClientException {
        if (logger.isTraceEnabled()) {
            logger.debug("introspectionRequest = " + introspectionRequest.toString());
        }
        return OauthHelper.getIntrospection(token, introspectionRequest, null);
    }

    public static String getKey(KeyRequest keyRequest, String envTag) throws ClientException {
        String serverUrl = keyRequest.getServerUrl();
        if (serverUrl == null) {
            Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
            serverUrl = cluster.serviceToUrl("https", keyRequest.getServiceId(), envTag, null);
        }
        if (serverUrl == null) {
            throw new ClientException(new Status(OAUTH_SERVER_URL_ERROR, "key"));
        }
        try {
            Map tlsMap;
            HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(ClientConfig.get().getTimeout())).sslContext(Http2Client.createSSLContext());
            if (!StringUtils.isBlank(keyRequest.getProxyHost())) {
                clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(keyRequest.getProxyHost(), keyRequest.getProxyPort() == 0 ? 443 : keyRequest.getProxyPort())));
            }
            if (keyRequest.isEnableHttp2()) {
                clientBuilder.version(HttpClient.Version.HTTP_2);
            }
            if ((tlsMap = (Map)ClientConfig.get().getMappedConfig().get("tls")) != null && !Boolean.TRUE.equals(tlsMap.get("verifyHostname"))) {
                Properties props = System.getProperties();
                props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
            }
            HttpClient keyClient = clientBuilder.build();
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().GET().uri(URI.create(serverUrl + keyRequest.getUri()));
            if (keyRequest.getClientId() != null && keyRequest.getClientSecret() != null) {
                requestBuilder.setHeader("Authorization", OauthHelper.getBasicAuthHeader(keyRequest.getClientId(), keyRequest.getClientSecret()));
            }
            HttpRequest request = requestBuilder.build();
            CompletableFuture<HttpResponse<String>> response = keyClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            return (String)((CompletableFuture)response.thenApply(HttpResponse::body)).get(ClientConfig.get().getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            throw new ClientException(e);
        }
    }

    public static Result<String> getIntrospection(String token, IntrospectionRequest introspectionRequest, String envTag) throws ClientException {
        String serverUrl;
        if (introspectionClient == null) {
            try {
                Map tlsMap;
                HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(ClientConfig.get().getTimeout())).sslContext(Http2Client.createSSLContext());
                if (logger.isTraceEnabled()) {
                    logger.trace("proxyHost = " + introspectionRequest.getProxyHost() + " proxyPort = " + introspectionRequest.getProxyPort());
                }
                if (!StringUtils.isBlank(introspectionRequest.getProxyHost())) {
                    clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(introspectionRequest.getProxyHost(), introspectionRequest.getProxyPort() == 0 ? 443 : introspectionRequest.getProxyPort())));
                }
                if (introspectionRequest.isEnableHttp2()) {
                    clientBuilder.version(HttpClient.Version.HTTP_2);
                }
                if ((tlsMap = (Map)ClientConfig.get().getMappedConfig().get("tls")) != null && !Boolean.TRUE.equals(tlsMap.get("verifyHostname"))) {
                    Properties props = System.getProperties();
                    props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
                }
                introspectionClient = clientBuilder.build();
            }
            catch (IOException e2) {
                logger.error("Cannot create HttpClient:", e2);
                return Failure.of(new Status(TLS_TRUSTSTORE_ERROR, new Object[0]));
            }
        }
        if ((serverUrl = introspectionRequest.getServerUrl()) == null) {
            Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
            serverUrl = cluster.serviceToUrl("https", introspectionRequest.getServiceId(), envTag, null);
        }
        if (serverUrl == null) {
            throw new ClientException(new Status(OAUTH_SERVER_URL_ERROR, "key"));
        }
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("token", token);
            String form = parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(form)).uri(URI.create(serverUrl + introspectionRequest.getUri()));
            if (introspectionRequest.getClientId() != null && introspectionRequest.getClientSecret() != null) {
                requestBuilder.setHeader("Authorization", OauthHelper.getBasicAuthHeader(introspectionRequest.getClientId(), introspectionRequest.getClientSecret()));
            }
            requestBuilder.setHeader("Content-Type", "application/x-www-form-urlencoded");
            HttpRequest request = requestBuilder.build();
            CompletableFuture<HttpResponse<String>> response = introspectionClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            String body = (String)((CompletableFuture)response.thenApply(HttpResponse::body)).get();
            return Success.of(body);
        }
        catch (Exception e3) {
            logger.error("Exception:", e3);
            throw new ClientException(e3);
        }
    }

    public static String derefToken(DerefRequest derefRequest) throws ClientException {
        return OauthHelper.derefToken(derefRequest, null);
    }

    public static String derefToken(DerefRequest derefRequest, String envTag) throws ClientException {
        if (derefClient == null) {
            try {
                Map tlsMap;
                HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(ClientConfig.get().getTimeout())).sslContext(Http2Client.createSSLContext());
                if (derefRequest.getProxyHost() != null) {
                    clientBuilder.proxy(ProxySelector.of(new InetSocketAddress(derefRequest.getProxyHost(), derefRequest.getProxyPort() == 0 ? 443 : derefRequest.getProxyPort())));
                }
                if (derefRequest.isEnableHttp2()) {
                    clientBuilder.version(HttpClient.Version.HTTP_2);
                }
                if ((tlsMap = (Map)ClientConfig.get().getMappedConfig().get("tls")) != null && !Boolean.TRUE.equals(tlsMap.get("verifyHostname"))) {
                    Properties props = System.getProperties();
                    props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
                }
                derefClient = clientBuilder.build();
            }
            catch (IOException e) {
                logger.error("Cannot create HttpClient:", e);
                throw new ClientException(e);
            }
        }
        try {
            String serverUrl = derefRequest.getServerUrl();
            if (serverUrl == null) {
                Cluster cluster = SingletonServiceFactory.getBean(Cluster.class);
                serverUrl = cluster.serviceToUrl("https", derefRequest.getServiceId(), envTag, null);
            }
            if (serverUrl == null) {
                throw new ClientException(new Status(OAUTH_SERVER_URL_ERROR, "deref"));
            }
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().GET().uri(URI.create(serverUrl + derefRequest.getUri()));
            if (derefRequest.getClientId() != null && derefRequest.getClientSecret() != null) {
                requestBuilder.setHeader("Authorization", OauthHelper.getBasicAuthHeader(derefRequest.getClientId(), derefRequest.getClientSecret()));
            }
            HttpRequest request = requestBuilder.build();
            CompletableFuture<HttpResponse<String>> response = derefClient.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            return (String)((CompletableFuture)response.thenApply(HttpResponse::body)).get(ClientConfig.get().getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            throw new ClientException(e);
        }
    }

    public static String getBasicAuthHeader(String clientId, String clientSecret) {
        return "Basic " + OauthHelper.encodeCredentials(clientId, clientSecret);
    }

    public static String encodeCredentials(String clientId, String clientSecret) {
        Object cred = clientSecret != null ? clientId + ":" + clientSecret : clientId;
        byte[] encodedBytes = Base64.encodeBase64(((String)cred).getBytes(StandardCharsets.UTF_8));
        String encodedValue = new String(encodedBytes, StandardCharsets.UTF_8);
        return encodedValue;
    }

    public static String getEncodedString(TokenRequest request) throws UnsupportedEncodingException {
        String csrf;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(GRANT_TYPE, request.getGrantType());
        if ("authorization_code".equals(request.getGrantType())) {
            params.put(CODE, ((AuthorizationCodeRequest)request).getAuthCode());
            if (((AuthorizationCodeRequest)request).getRedirectUri() != null) {
                params.put("redirect_uri", ((AuthorizationCodeRequest)request).getRedirectUri());
            }
            if ((csrf = request.getCsrf()) != null) {
                params.put("csrf", csrf);
            }
        }
        if ("client_authenticated_user".equals(request.getGrantType())) {
            params.put(USER_TYPE, ((ClientAuthenticatedUserRequest)request).getUserType());
            params.put(USER_ID, ((ClientAuthenticatedUserRequest)request).getUserId());
            params.put(ROLES, ((ClientAuthenticatedUserRequest)request).getRoles());
            if (((ClientAuthenticatedUserRequest)request).getRedirectUri() != null) {
                params.put("redirect_uri", ((ClientAuthenticatedUserRequest)request).getRedirectUri());
            }
            if ((csrf = request.getCsrf()) != null) {
                params.put("csrf", csrf);
            }
        }
        if ("refresh_token".equals(request.getGrantType())) {
            params.put("refresh_token", ((RefreshTokenRequest)request).getRefreshToken());
            csrf = request.getCsrf();
            if (csrf != null) {
                params.put("csrf", csrf);
            }
        }
        if (request.getScope() != null) {
            params.put("scope", String.join((CharSequence)" ", request.getScope()));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("token request form data = " + JsonMapper.toJson(params));
        }
        return Http2Client.getFormDataString(params);
    }

    private static Result<TokenResponse> handleResponse(ContentType contentType, String responseBody) {
        Result<TokenResponse> result;
        if (logger.isTraceEnabled()) {
            logger.trace("contentType = " + contentType + " responseBody = " + responseBody);
        }
        try {
            if (!contentType.equals((Object)ContentType.APPLICATION_JSON)) {
                return Failure.of(new Status(GET_TOKEN_ERROR, OauthHelper.escapeBasedOnType(contentType, responseBody)));
            }
            if (responseBody != null && responseBody.length() > 0) {
                TokenResponse tokenResponse = Config.getInstance().getMapper().readValue(responseBody, TokenResponse.class);
                result = tokenResponse != null && tokenResponse.getAccessToken() != null ? Success.of(tokenResponse) : Failure.of(new Status(tokenResponse.getStatusCode(), tokenResponse.getCode(), tokenResponse.getMessage(), tokenResponse.getDescription(), tokenResponse.getSeverity()));
            } else {
                result = Failure.of(new Status(GET_TOKEN_ERROR, "no auth server response"));
                logger.error("Error in token retrieval, response = " + responseBody);
            }
        }
        catch (UnrecognizedPropertyException e) {
            result = Failure.of(new Status(GET_TOKEN_ERROR, OauthHelper.escapeBasedOnType(contentType, responseBody)));
            logger.error("Error in token parsing", e);
        }
        catch (IOException | RuntimeException e) {
            result = Failure.of(new Status(GET_TOKEN_ERROR, e.getMessage()));
            logger.error("Error in token retrieval", e);
        }
        return result;
    }

    @Deprecated
    public static void sendStatusToResponse(HttpServerExchange exchange, Status status) {
        exchange.setStatusCode(status.getStatusCode());
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "application/json");
        exchange.getResponseSender().send(status.toString());
        logger.error(status.toString());
        if (logger.isTraceEnabled()) {
            StackTraceElement[] elements = Thread.currentThread().getStackTrace();
            String stackTrace = Arrays.stream(elements).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
            logger.trace(stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result<Jwt> populateCCToken(Jwt jwt) {
        boolean isInRenewWindow = jwt.getExpire() - System.currentTimeMillis() < Jwt.getTokenRenewBeforeExpired();
        logger.trace("isInRenewWindow = " + isInRenewWindow);
        if (!isInRenewWindow) {
            return Success.of(jwt);
        }
        Jwt jwt2 = jwt;
        synchronized (jwt2) {
            if (jwt.getExpire() <= System.currentTimeMillis()) {
                Result<Jwt> result = OauthHelper.renewCCTokenSync(jwt);
                if (logger.isTraceEnabled()) {
                    logger.trace("Check secondary token is done!");
                }
                return result;
            }
            OauthHelper.renewCCTokenAsync(jwt);
            if (logger.isTraceEnabled()) {
                logger.trace("Check secondary token is done!");
            }
            return Success.of(jwt);
        }
    }

    private static Result<Jwt> renewCCTokenSync(Jwt jwt) {
        logger.trace("In renew window and token is already expired.");
        if (!jwt.isRenewing() || System.currentTimeMillis() > jwt.getExpiredRetryTimeout()) {
            jwt.setRenewing(true);
            jwt.setEarlyRetryTimeout(System.currentTimeMillis() + Jwt.getExpiredRefreshRetryDelay());
            Result<Jwt> result = OauthHelper.getCCTokenRemotely(jwt);
            jwt.setRenewing(false);
            return result;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Circuit breaker is tripped and not timeout yet!");
        }
        return Failure.of(new Status(STATUS_CLIENT_CREDENTIALS_TOKEN_NOT_AVAILABLE, new Object[0]));
    }

    private static void renewCCTokenAsync(Jwt jwt) {
        logger.trace("In renew window but token is not expired yet.");
        if (!jwt.isRenewing() || System.currentTimeMillis() > jwt.getEarlyRetryTimeout()) {
            jwt.setRenewing(true);
            jwt.setEarlyRetryTimeout(System.currentTimeMillis() + Jwt.getEarlyRefreshRetryDelay());
            logger.trace("Retrieve token async is called while token is not expired yet");
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.schedule(() -> {
                Result<Jwt> result = OauthHelper.getCCTokenRemotely(jwt);
                if (result.isFailure()) {
                    logger.error("Async retrieve token error with status: {}", (Object)result.getError().toString());
                }
                jwt.setRenewing(false);
            }, 50L, TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
    }

    private static Result<Jwt> getCCTokenRemotely(Jwt jwt) {
        Result<TokenResponse> result;
        ClientCredentialsRequest tokenRequest = new ClientCredentialsRequest(jwt.getCcConfig());
        OauthHelper.setScope(tokenRequest, jwt);
        if (logger.isTraceEnabled()) {
            logger.trace("TokenRequest = " + JsonMapper.toJson(tokenRequest));
        }
        if ((result = OauthHelper.getTokenResult(tokenRequest)).isSuccess()) {
            TokenResponse tokenResponse = result.getResult();
            jwt.setJwt(tokenResponse.getAccessToken());
            jwt.setExpire(System.currentTimeMillis() + tokenResponse.getExpiresIn() * 1000L);
            logger.info("Get client credentials token {} with expire_in {} seconds", (Object)jwt.getJwt().substring(0, 20), (Object)tokenResponse.getExpiresIn());
            jwt.setScopes(tokenResponse.getScope());
            return Success.of(jwt);
        }
        logger.info("Get client credentials token fail with status: {}", (Object)result.getError().toString());
        return Failure.of(result.getError());
    }

    private static void setScope(TokenRequest tokenRequest, final Jwt jwt) {
        if (jwt.getKey() != null && jwt.getKey().getScopes() != null && !jwt.getKey().getScopes().isEmpty()) {
            tokenRequest.setScope((List<String>)new ArrayList<String>(){
                {
                    this.addAll(jwt.getKey().getScopes());
                }
            });
        }
    }

    public static ContentType getContentTypeHeaders(HttpHeaders headers) {
        Optional<String> contentType = headers.firstValue("Content-Type");
        return contentType.isEmpty() ? ContentType.ANY_TYPE : ContentType.toContentType(contentType.get());
    }

    private static String escapeBasedOnType(ContentType contentType, String responseBody) {
        switch (contentType) {
            case APPLICATION_JSON: {
                try {
                    String escapedStr = Config.getInstance().getMapper().writeValueAsString(responseBody);
                    return escapedStr.substring(1, escapedStr.length() - 1);
                }
                catch (JsonProcessingException e) {
                    logger.error("escape json response fails");
                    return responseBody;
                }
            }
            case XML: {
                return OauthHelper.escapeXml(responseBody);
            }
        }
        return responseBody;
    }

    private static String escapeXml(String nonEscapedXmlStr) {
        StringBuilder escapedXML = new StringBuilder();
        block7: for (int i = 0; i < nonEscapedXmlStr.length(); ++i) {
            char c = nonEscapedXmlStr.charAt(i);
            switch (c) {
                case '<': {
                    escapedXML.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escapedXML.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    escapedXML.append("&quot;");
                    continue block7;
                }
                case '&': {
                    escapedXML.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    escapedXML.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c > '~') {
                        escapedXML.append("&#" + c + ";");
                        continue block7;
                    }
                    escapedXML.append(c);
                }
            }
        }
        return escapedXML.toString();
    }
}

