/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.body;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.body.BodyConfig;
import com.networknt.config.Config;
import com.networknt.handler.BuffersUtils;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.ResponseInterceptor;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseBodyInterceptor
implements ResponseInterceptor {
    static final Logger logger = LoggerFactory.getLogger(ResponseBodyInterceptor.class);
    static final String CONTENT_TYPE_MISMATCH = "ERR10015";
    public static int MAX_BUFFERS = 1024;
    private BodyConfig config;
    private volatile HttpHandler next;

    public ResponseBodyInterceptor() {
        if (logger.isInfoEnabled()) {
            logger.info("ResponseBodyInterceptor is loaded");
        }
        this.config = BodyConfig.load();
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(ResponseBodyInterceptor.class.getName(), this.config.getMappedConfig(), null);
    }

    @Override
    public void reload() {
        this.config.reload();
    }

    @Override
    public boolean isRequiredContent() {
        return true;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("ResponseBodyInterceptor.handleRequest starts.");
        }
        if (this.shouldParseBody(exchange) && this.getBuffer(exchange) != null) {
            boolean attached;
            String s2 = BuffersUtils.toString(this.getBuffer(exchange), StandardCharsets.UTF_8);
            if (logger.isTraceEnabled()) {
                logger.trace("original response body = " + s2);
            }
            if (!(attached = this.attachJsonBody(exchange, s2)) && logger.isInfoEnabled()) {
                logger.info("Failed to attached the response body to the exchange");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ResponseBodyInterceptor.handleRequest ends.");
        }
    }

    private boolean shouldParseBody(HttpServerExchange exchange) {
        return this.isAttachContentType(exchange);
    }

    private boolean isAttachContentType(HttpServerExchange exchange) {
        String contentType = exchange.getResponseHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith("application/json") || contentType.startsWith("text") || contentType.startsWith("application/xml");
    }

    private boolean attachJsonBody(HttpServerExchange exchange, String string) {
        if ((string = string.trim()).startsWith("{")) {
            try {
                Map<String, Object> body = Config.getInstance().getMapper().readValue(string, new TypeReference<Map<String, Object>>(){});
                exchange.putAttachment(AttachmentConstants.RESPONSE_BODY, body);
            }
            catch (JsonProcessingException e) {
                if (logger.isTraceEnabled()) {
                    logger.error("Response body failed to attach with exception {}", (Object)e.getMessage(), (Object)e);
                }
                this.setExchangeStatus(exchange, CONTENT_TYPE_MISMATCH, "application/json");
                return false;
            }
        }
        if (string.startsWith("[")) {
            try {
                List<Object> body = Config.getInstance().getMapper().readValue(string, new TypeReference<List<Object>>(){});
                exchange.putAttachment(AttachmentConstants.RESPONSE_BODY, body);
            }
            catch (JsonProcessingException e) {
                if (logger.isTraceEnabled()) {
                    logger.error("Response body failed to attach with exception: {}", (Object)e.getMessage(), (Object)e);
                }
                this.setExchangeStatus(exchange, CONTENT_TYPE_MISMATCH, "application/json");
                return false;
            }
        }
        if (this.config.isCacheRequestBody()) {
            exchange.putAttachment(AttachmentConstants.RESPONSE_BODY_STRING, string);
        }
        return true;
    }
}

