/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.InputFormat;
import com.networknt.schema.MissingSchemaKeywordException;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaRegistryConfig;
import com.networknt.schema.Specification;
import com.networknt.schema.SpecificationVersion;
import com.networknt.schema.dialect.BasicDialectRegistry;
import com.networknt.schema.dialect.DefaultDialectRegistry;
import com.networknt.schema.dialect.Dialect;
import com.networknt.schema.dialect.DialectRegistry;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.ResourceLoaders;
import com.networknt.schema.resource.SchemaIdResolvers;
import com.networknt.schema.resource.SchemaLoader;
import com.networknt.schema.serialization.BasicNodeReader;
import com.networknt.schema.serialization.DefaultNodeReader;
import com.networknt.schema.serialization.NodeReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistry {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegistry.class);
    private final NodeReader nodeReader;
    private final String defaultDialectId;
    private final SchemaLoader schemaLoader;
    private final ConcurrentMap<SchemaLocation, Schema> schemaCache = new ConcurrentHashMap<SchemaLocation, Schema>();
    private final boolean schemaCacheEnabled;
    private final DialectRegistry dialectRegistry;
    private final SchemaRegistryConfig schemaRegistryConfig;

    private SchemaRegistry(NodeReader nodeReader, String defaultDialectId, SchemaLoader schemaLoader, boolean schemaCacheEnabled, DialectRegistry dialectRegistry, SchemaRegistryConfig schemaRegistryConfig) {
        this.nodeReader = nodeReader != null ? nodeReader : BasicNodeReader.getInstance();
        this.defaultDialectId = defaultDialectId;
        this.schemaLoader = schemaLoader != null ? schemaLoader : SchemaLoader.getDefault();
        this.schemaCacheEnabled = schemaCacheEnabled;
        this.dialectRegistry = dialectRegistry != null ? dialectRegistry : new DefaultDialectRegistry();
        this.schemaRegistryConfig = schemaRegistryConfig != null ? schemaRegistryConfig : SchemaRegistryConfig.getInstance();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SchemaRegistry withDefaultDialect(SpecificationVersion specificationVersion) {
        return SchemaRegistry.withDefaultDialect(specificationVersion, null);
    }

    public static SchemaRegistry withDefaultDialect(SpecificationVersion specificationVersion, Consumer<Builder> customizer) {
        Dialect dialect = Specification.getDialect(specificationVersion);
        return SchemaRegistry.withDefaultDialectId(dialect.getId(), customizer);
    }

    public static SchemaRegistry withDefaultDialectId(String dialectId, Consumer<Builder> customizer) {
        Builder builder = SchemaRegistry.builder().defaultDialectId(dialectId);
        if (customizer != null) {
            customizer.accept(builder);
        }
        return builder.build();
    }

    public static SchemaRegistry withDefaultDialect(Dialect dialect) {
        return SchemaRegistry.withDefaultDialect(dialect, null);
    }

    public static SchemaRegistry withDefaultDialect(Dialect dialect, Consumer<Builder> customizer) {
        Builder builder = SchemaRegistry.builder().defaultDialectId(dialect.getId()).dialectRegistry(new DefaultDialectRegistry(dialect));
        if (customizer != null) {
            customizer.accept(builder);
        }
        return builder.build();
    }

    public static SchemaRegistry withDialect(Dialect dialect) {
        return SchemaRegistry.withDialect(dialect, null);
    }

    public static SchemaRegistry withDialect(Dialect dialect, Consumer<Builder> customizer) {
        Builder builder = SchemaRegistry.builder().defaultDialectId(dialect.getId()).dialectRegistry(new BasicDialectRegistry(dialect));
        if (customizer != null) {
            customizer.accept(builder);
        }
        return builder.build();
    }

    public static SchemaRegistry withDialects(List<Dialect> dialects) {
        return SchemaRegistry.withDialects(dialects, null);
    }

    public static SchemaRegistry withDialects(List<Dialect> dialects, Consumer<Builder> customizer) {
        Builder builder = SchemaRegistry.builder().defaultDialectId(dialects.get(0).getId()).dialectRegistry(new BasicDialectRegistry(dialects));
        if (customizer != null) {
            customizer.accept(builder);
        }
        return builder.build();
    }

    public static Builder builder(SchemaRegistry blueprint) {
        Builder builder = SchemaRegistry.builder().schemaLoader(blueprint.schemaLoader).defaultDialectId(blueprint.defaultDialectId).nodeReader(blueprint.nodeReader).dialectRegistry(blueprint.dialectRegistry).schemaRegistryConfig(blueprint.schemaRegistryConfig);
        return builder;
    }

    public SchemaLoader getSchemaLoader() {
        return this.schemaLoader;
    }

    protected Schema newSchema(SchemaLocation schemaUri, JsonNode schemaNode) {
        SchemaContext schemaContext = this.createSchemaContext(schemaNode);
        Schema jsonSchema = this.doCreate(schemaContext, this.getSchemaLocation(schemaUri), schemaNode, null, false);
        this.preload(jsonSchema);
        return jsonSchema;
    }

    private void preload(Schema schema) {
        if (this.getSchemaRegistryConfig().isPreloadSchema()) {
            try {
                schema.initializeValidators();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Schema create(SchemaContext schemaContext, SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema) {
        return this.doCreate(schemaContext, schemaLocation, schemaNode, parentSchema, false);
    }

    private Schema doCreate(SchemaContext schemaContext, SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, boolean suppressSubSchemaRetrieval) {
        return Schema.from(this.withDialect(schemaContext, schemaNode), schemaLocation, schemaNode, parentSchema, suppressSubSchemaRetrieval);
    }

    private SchemaContext withDialect(SchemaContext schemaContext, JsonNode schemaNode) {
        Dialect dialect = this.getDialect(schemaNode, schemaContext.getSchemaRegistryConfig());
        if (dialect != null && !dialect.getId().equals(schemaContext.getDialect().getId())) {
            return new SchemaContext(dialect, schemaContext.getSchemaRegistry(), schemaContext.getSchemaReferences(), schemaContext.getSchemaResources(), schemaContext.getDynamicAnchors());
        }
        return schemaContext;
    }

    protected SchemaLocation getSchemaLocation(SchemaLocation schemaLocation) {
        return schemaLocation != null ? schemaLocation : SchemaLocation.DOCUMENT;
    }

    protected SchemaContext createSchemaContext(JsonNode schemaNode) {
        Dialect dialect = this.getDialectOrDefault(schemaNode);
        return new SchemaContext(dialect, this);
    }

    private Dialect getDialect(JsonNode schemaNode, SchemaRegistryConfig config) {
        JsonNode iriNode = schemaNode.get("$schema");
        if (iriNode != null && iriNode.isTextual()) {
            return this.getDialect(iriNode.textValue());
        }
        return null;
    }

    private Dialect getDialectOrDefault(JsonNode schemaNode) {
        String iri;
        JsonNode iriNode = schemaNode.get("$schema");
        if (iriNode != null && !iriNode.isNull() && !iriNode.isTextual()) {
            throw new SchemaException("Unknown dialect: " + iriNode);
        }
        String string = iri = iriNode == null || iriNode.isNull() ? this.defaultDialectId : iriNode.textValue();
        if (iri == null) {
            throw new MissingSchemaKeywordException("The $schema keyword that indicates the schema dialect must be specified.");
        }
        return this.getDialect(iri);
    }

    public Dialect getDialect(String dialectId) {
        String key = SchemaRegistry.normalizeDialectId(dialectId);
        return this.dialectRegistry.getDialect(key, this);
    }

    JsonNode readTree(String content, InputFormat inputFormat) throws IOException {
        return this.nodeReader.readTree(content, inputFormat);
    }

    JsonNode readTree(InputStream content, InputFormat inputFormat) throws IOException {
        return this.nodeReader.readTree(content, inputFormat);
    }

    public Schema getSchema(String schema) {
        return this.getSchema(schema, InputFormat.JSON);
    }

    public Schema getSchema(String schema, InputFormat inputFormat) {
        try {
            JsonNode schemaNode = this.readTree(schema, inputFormat);
            return this.newSchema(null, schemaNode);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new SchemaException(ioe);
        }
    }

    public Schema getSchema(InputStream schemaStream) {
        return this.getSchema(schemaStream, InputFormat.JSON);
    }

    public Schema getSchema(InputStream schemaStream, InputFormat inputFormat) {
        try {
            JsonNode schemaNode = this.readTree(schemaStream, inputFormat);
            return this.newSchema(null, schemaNode);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new SchemaException(ioe);
        }
    }

    public Schema getSchema(SchemaLocation schemaUri) {
        Schema schema = this.loadSchema(schemaUri);
        this.preload(schema);
        return schema;
    }

    public Schema getSchema(SchemaLocation schemaUri, JsonNode jsonNode) {
        return this.newSchema(schemaUri, jsonNode);
    }

    public Schema getSchema(SchemaLocation schemaUri, String schema, InputFormat inputFormat) {
        try {
            JsonNode schemaNode = this.readTree(schema, inputFormat);
            return this.newSchema(schemaUri, schemaNode);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new SchemaException(ioe);
        }
    }

    public Schema getSchema(SchemaLocation schemaUri, InputStream schemaStream, InputFormat inputFormat) {
        try {
            JsonNode schemaNode = this.readTree(schemaStream, inputFormat);
            return this.newSchema(schemaUri, schemaNode);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new SchemaException(ioe);
        }
    }

    public Schema getSchema(JsonNode jsonNode) {
        return this.newSchema(null, jsonNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema loadSchema(SchemaLocation schemaUri) {
        if (this.schemaCacheEnabled) {
            Schema cachedUriSchema = (Schema)this.schemaCache.get(schemaUri);
            if (cachedUriSchema == null) {
                SchemaRegistry schemaRegistry = this;
                synchronized (schemaRegistry) {
                    cachedUriSchema = (Schema)this.schemaCache.get(schemaUri);
                    if (cachedUriSchema == null && (cachedUriSchema = this.getMappedSchema(schemaUri)) != null) {
                        this.schemaCache.put(schemaUri, cachedUriSchema);
                    }
                }
            }
            return cachedUriSchema;
        }
        return this.getMappedSchema(schemaUri);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Schema getMappedSchema(SchemaLocation schemaUri) {
        InputStreamSource inputStreamSource = this.schemaLoader.getSchemaResource(schemaUri.getAbsoluteIri());
        if (inputStreamSource == null) throw new SchemaException(new FileNotFoundException(schemaUri.getAbsoluteIri().toString()));
        try (InputStream inputStream = inputStreamSource.getInputStream();){
            JsonNode schemaNode222;
            if (inputStream == null) {
                throw new IOException("Cannot load schema at " + schemaUri);
            }
            if (this.isYaml(schemaUri)) {
                JsonNode schemaNode = this.readTree(inputStream, InputFormat.YAML);
            } else {
                schemaNode222 = this.readTree(inputStream, InputFormat.JSON);
            }
            Dialect dialect = this.getDialectOrDefault(schemaNode222);
            if (schemaUri.getFragment() == null || schemaUri.getFragment().getNameCount() == 0) {
                SchemaContext schemaContext = new SchemaContext(dialect, this);
                Schema schema = this.doCreate(schemaContext, schemaUri, schemaNode222, null, true);
                return schema;
            }
            SchemaContext schemaContext = this.createSchemaContext(schemaNode222);
            SchemaLocation documentLocation = new SchemaLocation(schemaUri.getAbsoluteIri());
            Schema document = this.doCreate(schemaContext, documentLocation, schemaNode222, null, false);
            Schema schema = document.getRefSchema(schemaUri.getFragment());
            return schema;
        }
        catch (IOException e) {
            logger.error("Failed to load json schema from {}", (Object)schemaUri.getAbsoluteIri(), (Object)e);
            SchemaException exception = new SchemaException("Failed to load json schema from " + schemaUri.getAbsoluteIri());
            exception.initCause(e);
            throw exception;
        }
    }

    public SchemaRegistryConfig getSchemaRegistryConfig() {
        return this.schemaRegistryConfig;
    }

    private boolean isYaml(SchemaLocation schemaUri) {
        String schemeSpecificPart = schemaUri.getAbsoluteIri().toString();
        int idx = schemeSpecificPart.lastIndexOf(46);
        if (idx == -1) {
            return false;
        }
        String extension = schemeSpecificPart.substring(idx);
        return ".yml".equals(extension) || ".yaml".equals(extension);
    }

    protected static String normalizeDialectId(String id) {
        boolean found = false;
        for (SpecificationVersion flag : SpecificationVersion.values()) {
            if (!flag.getDialectId().equals(id)) continue;
            found = true;
            break;
        }
        if (!found && id.contains("://json-schema.org/draft")) {
            if (id.contains("/draft-07/")) {
                id = "http://json-schema.org/draft-07/schema#";
            } else if (id.contains("/draft/2019-09/")) {
                id = "https://json-schema.org/draft/2019-09/schema";
            } else if (id.contains("/draft/2020-12/")) {
                id = "https://json-schema.org/draft/2020-12/schema";
            } else if (id.contains("/draft-04/")) {
                id = "http://json-schema.org/draft-04/schema#";
            } else if (id.contains("/draft-06/")) {
                id = "http://json-schema.org/draft-06/schema#";
            }
        }
        return id;
    }

    public static class Builder {
        private String defaultDialectId;
        private DialectRegistry dialectRegistry = null;
        private NodeReader nodeReader = null;
        private SchemaLoader schemaLoader = null;
        private boolean schemaCacheEnabled = true;
        private SchemaRegistryConfig schemaRegistryConfig = null;

        public Builder nodeReader(NodeReader nodeReader) {
            this.nodeReader = nodeReader;
            return this;
        }

        public Builder nodeReader(Consumer<DefaultNodeReader.Builder> customizer) {
            DefaultNodeReader.Builder builder = NodeReader.builder();
            customizer.accept(builder);
            this.nodeReader = builder.build();
            return this;
        }

        public Builder defaultDialectId(String defaultDialectId) {
            this.defaultDialectId = defaultDialectId;
            return this;
        }

        public Builder dialectRegistry(DialectRegistry dialectRegistry) {
            this.dialectRegistry = dialectRegistry;
            return this;
        }

        public Builder schemaCacheEnabled(boolean schemaCacheEnabled) {
            this.schemaCacheEnabled = schemaCacheEnabled;
            return this;
        }

        public Builder schemaLoader(SchemaLoader schemaLoader) {
            this.schemaLoader = schemaLoader;
            return this;
        }

        public Builder schemaLoader(Consumer<SchemaLoader.Builder> customizer) {
            SchemaLoader.Builder builder = null;
            builder = this.schemaLoader != null ? SchemaLoader.builder(this.schemaLoader) : SchemaLoader.builder();
            customizer.accept(builder);
            this.schemaLoader = builder.build();
            return this;
        }

        public Builder resourceLoaders(Consumer<ResourceLoaders.Builder> customizer) {
            SchemaLoader.Builder builder = null;
            builder = this.schemaLoader != null ? SchemaLoader.builder(this.schemaLoader) : SchemaLoader.builder();
            customizer.accept(builder.getResourceLoadersBuilder());
            this.schemaLoader = builder.build();
            return this;
        }

        public Builder schemaIdResolvers(Consumer<SchemaIdResolvers.Builder> customizer) {
            SchemaLoader.Builder builder = null;
            builder = this.schemaLoader != null ? SchemaLoader.builder(this.schemaLoader) : SchemaLoader.builder();
            customizer.accept(builder.getSchemaIdResolversBuilder());
            this.schemaLoader = builder.build();
            return this;
        }

        public Builder schemaRegistryConfig(SchemaRegistryConfig schemaRegistryConfig) {
            this.schemaRegistryConfig = schemaRegistryConfig;
            return this;
        }

        public Builder schemas(Map<String, String> schemas) {
            return this.resourceLoaders(resourceLoaders -> resourceLoaders.resources(schemas));
        }

        public Builder schemas(Function<String, String> schemas) {
            return this.resourceLoaders(resourceLoaders -> resourceLoaders.resources(schemas));
        }

        public <T> Builder schemas(Function<String, T> mapIriToObject, Function<T, String> mapObjectToData) {
            return this.resourceLoaders(resourceLoaders -> resourceLoaders.resources(mapIriToObject, mapObjectToData));
        }

        public SchemaRegistry build() {
            return new SchemaRegistry(this.nodeReader, this.defaultDialectId, this.schemaLoader, this.schemaCacheEnabled, this.dialectRegistry, this.schemaRegistryConfig);
        }
    }
}

