/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.SpecVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Vocabularies {
    private static final Map<String, List<String>> KEYWORDS_MAPPING;

    public static List<String> getKeywords(String vocabulary) {
        return KEYWORDS_MAPPING.get(vocabulary);
    }

    public static String getVocabulary(SpecVersion.VersionFlag specification, String vocabulary) {
        String base = specification.getId().substring(0, specification.getId().lastIndexOf(47));
        return base + "/vocab/" + vocabulary;
    }

    static {
        HashMap<String, List<String>> mapping = new HashMap<String, List<String>>();
        ArrayList<String> validation = new ArrayList<String>();
        validation.add("type");
        validation.add("enum");
        validation.add("const");
        validation.add("multipleOf");
        validation.add("maximum");
        validation.add("exclusiveMaximum");
        validation.add("minimum");
        validation.add("exclusiveMinimum");
        validation.add("maxLength");
        validation.add("minLength");
        validation.add("pattern");
        validation.add("maxItems");
        validation.add("minItems");
        validation.add("uniqueItems");
        validation.add("maxContains");
        validation.add("minContains");
        validation.add("maxProperties");
        validation.add("minProperties");
        validation.add("required");
        validation.add("dependentRequired");
        mapping.put("validation", validation);
        KEYWORDS_MAPPING = mapping;
    }
}

