/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.uri.ClasspathURLFactory;
import com.networknt.schema.uri.ClasspathURLFetcher;
import com.networknt.schema.uri.URIFactory;
import com.networknt.schema.uri.URIFetcher;
import com.networknt.schema.uri.URISchemeFactory;
import com.networknt.schema.uri.URISchemeFetcher;
import com.networknt.schema.uri.URLFactory;
import com.networknt.schema.uri.URLFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaFactory {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaFactory.class);
    private final ObjectMapper mapper;
    private final String defaultMetaSchemaURI;
    private final URISchemeFactory uriFactory;
    private final URISchemeFetcher uriFetcher;
    private final Map<String, JsonMetaSchema> jsonMetaSchemas;
    private final Map<String, String> uriMap;

    private JsonSchemaFactory(ObjectMapper mapper, String defaultMetaSchemaURI, URISchemeFactory uriFactory, URISchemeFetcher uriFetcher, Map<String, JsonMetaSchema> jsonMetaSchemas, Map<String, String> uriMap) {
        if (mapper == null) {
            throw new IllegalArgumentException("ObjectMapper must not be null");
        }
        if (defaultMetaSchemaURI == null || defaultMetaSchemaURI.trim().isEmpty()) {
            throw new IllegalArgumentException("defaultMetaSchemaURI must not be null or empty");
        }
        if (uriFactory == null) {
            throw new IllegalArgumentException("URIFactory must not be null");
        }
        if (uriFetcher == null) {
            throw new IllegalArgumentException("URIFetcher must not be null");
        }
        if (jsonMetaSchemas == null || jsonMetaSchemas.isEmpty()) {
            throw new IllegalArgumentException("Json Meta Schemas must not be null or empty");
        }
        if (jsonMetaSchemas.get(defaultMetaSchemaURI) == null) {
            throw new IllegalArgumentException("Meta Schema for default Meta Schema URI must be provided");
        }
        if (uriMap == null) {
            throw new IllegalArgumentException("URL Mappings must not be null");
        }
        this.mapper = mapper;
        this.defaultMetaSchemaURI = defaultMetaSchemaURI;
        this.uriFactory = uriFactory;
        this.uriFetcher = uriFetcher;
        this.jsonMetaSchemas = jsonMetaSchemas;
        this.uriMap = uriMap;
    }

    static Builder builder() {
        return new Builder();
    }

    public static JsonSchemaFactory getInstance() {
        JsonMetaSchema draftV4 = JsonMetaSchema.getDraftV4();
        return JsonSchemaFactory.builder().defaultMetaSchemaURI(draftV4.getUri()).addMetaSchema(draftV4).build();
    }

    public static Builder builder(JsonSchemaFactory blueprint) {
        Builder builder = JsonSchemaFactory.builder().addMetaSchemas(blueprint.jsonMetaSchemas.values()).defaultMetaSchemaURI(blueprint.defaultMetaSchemaURI).objectMapper(blueprint.mapper).addUriMappings(blueprint.uriMap);
        for (Map.Entry<String, URIFactory> entry : blueprint.uriFactory.getURIFactories().entrySet()) {
            builder = builder.uriFactory(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : blueprint.uriFetcher.getURIFetchers().entrySet()) {
            builder = builder.uriFetcher((URIFetcher)entry.getValue(), entry.getKey());
        }
        return builder;
    }

    private JsonSchema newJsonSchema(URI schemaUri, JsonNode schemaNode, SchemaValidatorsConfig config) {
        ValidationContext validationContext = this.createValidationContext(schemaNode);
        validationContext.setConfig(config);
        JsonSchema jsonSchema = new JsonSchema(validationContext, schemaUri, schemaNode);
        return jsonSchema;
    }

    protected ValidationContext createValidationContext(JsonNode schemaNode) {
        JsonMetaSchema jsonMetaSchema = this.findMetaSchemaForSchema(schemaNode);
        return new ValidationContext(this.uriFactory, jsonMetaSchema, this, null);
    }

    private JsonMetaSchema findMetaSchemaForSchema(JsonNode schemaNode) {
        JsonNode uriNode = schemaNode.get("$schema");
        String uri = uriNode == null || uriNode.isNull() ? this.defaultMetaSchemaURI : uriNode.textValue();
        JsonMetaSchema jsonMetaSchema = this.jsonMetaSchemas.get(uri);
        if (jsonMetaSchema == null) {
            throw new JsonSchemaException("Unknown Metaschema: " + uri);
        }
        return jsonMetaSchema;
    }

    public URIFactory getUriFactory() {
        return this.uriFactory;
    }

    public JsonSchema getSchema(String schema, SchemaValidatorsConfig config) {
        try {
            JsonNode schemaNode = this.mapper.readTree(schema);
            return this.newJsonSchema(null, schemaNode, config);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(String schema) {
        return this.getSchema(schema, null);
    }

    public JsonSchema getSchema(InputStream schemaStream, SchemaValidatorsConfig config) {
        try {
            JsonNode schemaNode = this.mapper.readTree(schemaStream);
            return this.newJsonSchema(null, schemaNode, config);
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(InputStream schemaStream) {
        return this.getSchema(schemaStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonSchema getSchema(URI schemaUri, SchemaValidatorsConfig config) {
        try {
            URI mappedUri;
            InputStream inputStream = null;
            HashMap<String, String> map = config != null ? config.getUriMappings() : new HashMap<String, String>(this.uriMap);
            map.putAll(this.uriMap);
            try {
                mappedUri = this.uriFactory.create(map.getOrDefault(schemaUri.toString(), schemaUri.toString()));
            }
            catch (IllegalArgumentException e) {
                logger.error("Failed to create URI.", (Throwable)e);
                throw new JsonSchemaException(e);
            }
            try {
                inputStream = this.uriFetcher.fetch(mappedUri);
                JsonNode schemaNode = this.mapper.readTree(inputStream);
                JsonMetaSchema jsonMetaSchema = this.findMetaSchemaForSchema(schemaNode);
                if (this.idMatchesSourceUri(jsonMetaSchema, schemaNode, schemaUri)) {
                    JsonSchema jsonSchema2 = new JsonSchema(new ValidationContext(this.uriFactory, jsonMetaSchema, this, config), mappedUri, schemaNode, true);
                    return jsonSchema2;
                }
                JsonSchema jsonSchema = this.newJsonSchema(mappedUri, schemaNode, config);
                return jsonSchema;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException ioe) {
            logger.error("Failed to load json schema!", (Throwable)ioe);
            throw new JsonSchemaException(ioe);
        }
    }

    public JsonSchema getSchema(URI schemaUri) {
        return this.getSchema(schemaUri, new SchemaValidatorsConfig());
    }

    public JsonSchema getSchema(URI schemaUri, JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(schemaUri, jsonNode, config);
    }

    public JsonSchema getSchema(JsonNode jsonNode, SchemaValidatorsConfig config) {
        return this.newJsonSchema(null, jsonNode, config);
    }

    public JsonSchema getSchema(URI schemaUri, JsonNode jsonNode) {
        return this.newJsonSchema(schemaUri, jsonNode, null);
    }

    public JsonSchema getSchema(JsonNode jsonNode) {
        return this.newJsonSchema(null, jsonNode, null);
    }

    private boolean idMatchesSourceUri(JsonMetaSchema metaSchema, JsonNode schema, URI schemaUri) {
        String id = metaSchema.readId(schema);
        if (id == null || id.isEmpty()) {
            return false;
        }
        boolean result = id.equals(schemaUri.toString());
        if (logger.isDebugEnabled()) {
            logger.debug("Matching " + id + " to " + schemaUri.toString() + ": " + result);
        }
        return result;
    }

    public static class Builder {
        private ObjectMapper objectMapper = new ObjectMapper();
        private String defaultMetaSchemaURI;
        private final Map<String, URIFactory> uriFactoryMap = new HashMap<String, URIFactory>();
        private final Map<String, URIFetcher> uriFetcherMap = new HashMap<String, URIFetcher>();
        private final Map<String, JsonMetaSchema> jsonMetaSchemas = new HashMap<String, JsonMetaSchema>();
        private final Map<String, String> uriMap = new HashMap<String, String>();

        public Builder() {
            URLFactory urlFactory = new URLFactory();
            for (String string : URLFactory.SUPPORTED_SCHEMES) {
                this.uriFactoryMap.put(string, urlFactory);
            }
            URLFetcher urlFetcher = new URLFetcher();
            for (String scheme : URLFetcher.SUPPORTED_SCHEMES) {
                this.uriFetcherMap.put(scheme, urlFetcher);
            }
            ClasspathURLFactory classpathURLFactory = new ClasspathURLFactory();
            ClasspathURLFetcher classpathURLFetcher = new ClasspathURLFetcher();
            for (String scheme : ClasspathURLFactory.SUPPORTED_SCHEMES) {
                this.uriFactoryMap.put(scheme, classpathURLFactory);
                this.uriFetcherMap.put(scheme, classpathURLFetcher);
            }
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder defaultMetaSchemaURI(String defaultMetaSchemaURI) {
            this.defaultMetaSchemaURI = defaultMetaSchemaURI;
            return this;
        }

        public Builder uriFactory(URIFactory uriFactory, String ... schemes) {
            for (String scheme : schemes) {
                this.uriFactoryMap.put(scheme, uriFactory);
            }
            return this;
        }

        public Builder uriFetcher(URIFetcher uriFetcher, String ... schemes) {
            for (String scheme : schemes) {
                this.uriFetcherMap.put(scheme, uriFetcher);
            }
            return this;
        }

        public Builder addMetaSchema(JsonMetaSchema jsonMetaSchema) {
            this.jsonMetaSchemas.put(jsonMetaSchema.getUri(), jsonMetaSchema);
            return this;
        }

        public Builder addMetaSchemas(Collection<? extends JsonMetaSchema> jsonMetaSchemas) {
            for (JsonMetaSchema jsonMetaSchema : jsonMetaSchemas) {
                this.jsonMetaSchemas.put(jsonMetaSchema.getUri(), jsonMetaSchema);
            }
            return this;
        }

        public Builder addUriMappings(Map<String, String> map) {
            this.uriMap.putAll(map);
            return this;
        }

        public JsonSchemaFactory build() {
            return new JsonSchemaFactory(this.objectMapper == null ? new ObjectMapper() : this.objectMapper, this.defaultMetaSchemaURI, new URISchemeFactory(this.uriFactoryMap), new URISchemeFetcher(this.uriFetcherMap), this.jsonMetaSchemas, this.uriMap);
        }
    }
}

