/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.RequiredValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyOfValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public AnyOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ANY_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new JsonSchema(validationContext, this.getValidatorType().getValue(), schemaNode.get(i), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        String typeValidatorName = "anyOf/type";
        JsonType nodeType = TypeFactory.getValueNodeType(node);
        ArrayList<JsonSchema> filteredSchemaList = new ArrayList<JsonSchema>();
        ArrayList<String> expectedTypeList = new ArrayList<String>();
        for (JsonSchema schema : this.schemas) {
            if (schema.validators.containsKey(typeValidatorName)) {
                JsonType schemaType = ((TypeValidator)schema.validators.get(typeValidatorName)).getSchemaType();
                if (schemaType == nodeType) {
                    filteredSchemaList.add(schema);
                }
                expectedTypeList.add(schemaType.toString());
                continue;
            }
            filteredSchemaList.add(schema);
        }
        if (!this.schemas.isEmpty() && filteredSchemaList.isEmpty()) {
            return Collections.singleton(this.buildValidationMessage(at, StringUtils.join((Object[])new List[]{expectedTypeList})));
        }
        LinkedHashSet<ValidationMessage> allErrors = new LinkedHashSet<ValidationMessage>();
        for (JsonSchema schema : filteredSchemaList) {
            Set<ValidationMessage> errors = schema.validate(node, rootNode, at);
            if (errors.isEmpty()) {
                return errors;
            }
            allErrors.addAll(errors);
        }
        return Collections.unmodifiableSet(allErrors);
    }
}

