/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.balance;

import com.networknt.balance.LoadBalance;
import com.networknt.registry.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentHashLoadBalance
implements LoadBalance {
    static Logger logger = LoggerFactory.getLogger(ConsistentHashLoadBalance.class);

    public ConsistentHashLoadBalance() {
        if (logger.isInfoEnabled()) {
            logger.info("A ConsistentHashLoadBalance instance is started");
        }
    }

    @Override
    public URL select(List<URL> urls, String serviceId, String tag, String requestKey) {
        URL url = null;
        if (urls.size() > 1) {
            url = this.doSelect(urls, requestKey);
        } else if (urls.size() == 1) {
            url = urls.get(0);
        }
        return url;
    }

    private URL doSelect(List<URL> urls, String requestKey) {
        int hash = this.getHash(requestKey);
        return urls.get(hash % urls.size());
    }

    private int getHash(String hashKey) {
        int hashcode = hashKey != null ? hashKey.hashCode() : 0;
        return this.getPositive(hashcode);
    }
}

