/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.std;

import com.netflix.spectator.controllers.shaded.spectator-spring.json.core.JsonGenerator;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.core.JsonToken;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.core.type.WritableTypeId;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JavaType;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonMappingException;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.JsonNode;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.SerializerProvider;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.annotation.JacksonStdImpl;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsonFormatVisitors.JsonFormatTypes;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.jsontype.TypeSerializer;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.node.ObjectNode;
import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

