/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.filter;

import com.netflix.spectator.controllers.shaded.spectator-spring.json.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrototypeMeasurementFilterSpecification {
    private final Map<String, MeterFilterSpecification> include = new HashMap<String, MeterFilterSpecification>();
    private final Map<String, MeterFilterSpecification> exclude = new HashMap<String, MeterFilterSpecification>();

    public static PrototypeMeasurementFilterSpecification loadFromPath(String path) throws IOException {
        byte[] jsonData = Files.readAllBytes(Paths.get(path, new String[0]));
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readValue(jsonData, PrototypeMeasurementFilterSpecification.class);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PrototypeMeasurementFilterSpecification)) {
            return false;
        }
        PrototypeMeasurementFilterSpecification other = (PrototypeMeasurementFilterSpecification)obj;
        return this.include.equals(other.include) && this.exclude.equals(other.exclude);
    }

    public int hashCode() {
        return Objects.hash(this.include, this.exclude);
    }

    public String toString() {
        return String.format("INCLUDE=%s%nEXCLUDE=%s", this.include.toString(), this.exclude.toString());
    }

    public Map<String, MeterFilterSpecification> getInclude() {
        return this.include;
    }

    public Map<String, MeterFilterSpecification> getExclude() {
        return this.exclude;
    }

    public static class MeterFilterSpecification {
        private final List<ValueFilterSpecification> values = new ArrayList<ValueFilterSpecification>();

        public MeterFilterSpecification() {
        }

        public MeterFilterSpecification(List<ValueFilterSpecification> values) {
            this.values.addAll(values);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MeterFilterSpecification)) {
                return false;
            }
            MeterFilterSpecification other = (MeterFilterSpecification)obj;
            return this.values.equals(other.values);
        }

        public int hashCode() {
            return this.values.hashCode();
        }

        public String toString() {
            return this.values.toString();
        }

        public List<ValueFilterSpecification> getValues() {
            return this.values;
        }
    }

    public static class ValueFilterSpecification {
        static final ValueFilterSpecification ALL = new ValueFilterSpecification();
        private final List<TagFilterSpecification> tags = new ArrayList<TagFilterSpecification>();

        ValueFilterSpecification() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ValueFilterSpecification)) {
                return false;
            }
            ValueFilterSpecification other = (ValueFilterSpecification)obj;
            return this.tags.equals(other.tags);
        }

        public int hashCode() {
            return this.tags.hashCode();
        }

        public String toString() {
            return this.tags.toString();
        }

        public List<TagFilterSpecification> getTags() {
            return this.tags;
        }

        static {
            ValueFilterSpecification.ALL.tags.add(new TagFilterSpecification(".*", ".*"));
        }
    }

    public static class TagFilterSpecification {
        private final String key;
        private final String value;

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public TagFilterSpecification() {
            this.key = null;
            this.value = null;
        }

        public TagFilterSpecification(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TagFilterSpecification)) {
                return false;
            }
            TagFilterSpecification other = (TagFilterSpecification)obj;
            return this.key.equals(other.key) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return String.format("%s=%s", this.key, this.value);
        }
    }
}

