/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.model;

import com.netflix.spectator.api.Measurement;
import java.util.Objects;

public class DataPoint {
    private final long timestamp;
    private final double value;

    public static DataPoint make(Measurement m) {
        return new DataPoint(m.timestamp(), m.value());
    }

    public long getT() {
        return this.timestamp;
    }

    public double getV() {
        return this.value;
    }

    public DataPoint(long timestamp, double value) {
        this.timestamp = timestamp;
        this.value = value;
    }

    public String toString() {
        return String.format("t=%d, v=%f", this.timestamp, this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataPoint)) {
            return false;
        }
        DataPoint other = (DataPoint)obj;
        return this.timestamp == other.timestamp && Math.abs(this.value - other.value) < 0.001;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value);
    }
}

