/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.controllers.model;

import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.controllers.model.DataPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TaggedDataPoints {
    private List<Tag> tags;
    private List<DataPoint> dataPoints;

    public Iterable<Tag> getTags() {
        return this.tags;
    }

    public Iterable<DataPoint> getValues() {
        return this.dataPoints;
    }

    public TaggedDataPoints(Measurement measurement) {
        this.tags = JacksonableTag.convertTags(measurement.id().tags());
        this.dataPoints = Arrays.asList(DataPoint.make(measurement));
    }

    public TaggedDataPoints(Iterable<Tag> tags, List<DataPoint> dataPoints) {
        this.tags = JacksonableTag.convertTags(tags);
        this.dataPoints = dataPoints;
    }

    public String toString() {
        return String.format("{TAGS={%s} DATA={%s}", this.tags, this.dataPoints);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TaggedDataPoints)) {
            return false;
        }
        TaggedDataPoints other = (TaggedDataPoints)obj;
        return this.tags.equals(other.tags) && this.dataPoints.equals(other.dataPoints);
    }

    public int hashCode() {
        return Objects.hash(this.tags, this.dataPoints);
    }

    private static class JacksonableTag
    implements Tag {
        private String key;
        private String value;

        JacksonableTag(Tag tag) {
            this.key = tag.key();
            this.value = tag.value();
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Tag)) {
                return false;
            }
            Tag tag = (Tag)obj;
            return this.key.equals(tag.key()) && this.value.equals(tag.value());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        static List<Tag> convertTags(Iterable<Tag> iterable) {
            ArrayList<Tag> result = new ArrayList<Tag>();
            for (Tag tag : iterable) {
                result.add(new JacksonableTag(tag));
            }
            return result;
        }
    }
}

