/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.AbstractTimer;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.impl.SwapMeter;
import java.util.concurrent.TimeUnit;

final class SwapTimer
extends AbstractTimer
implements SwapMeter<Timer> {
    private final Registry registry;
    private final Id id;
    private volatile Timer underlying;

    SwapTimer(Registry registry, Id id, Timer underlying) {
        super(registry.clock());
        this.registry = registry;
        this.id = id;
        this.underlying = underlying;
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return this.get().measure();
    }

    @Override
    public boolean hasExpired() {
        Timer t = this.underlying;
        return t == null || t.hasExpired();
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        this.get().record(amount, unit);
    }

    @Override
    public long count() {
        return this.get().count();
    }

    @Override
    public long totalTime() {
        return this.get().totalTime();
    }

    @Override
    public void set(Timer t) {
        this.underlying = t;
    }

    @Override
    public Timer get() {
        Timer t = this.underlying;
        if (t == null) {
            this.underlying = t = this.unwrap(this.registry.timer(this.id));
        }
        return t;
    }

    private Timer unwrap(Timer t) {
        Timer tmp = t;
        while (tmp instanceof SwapTimer) {
            tmp = ((SwapTimer)tmp).get();
        }
        return tmp;
    }
}

