/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.patterns;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Functions;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Statistic;
import com.netflix.spectator.api.Utils;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class IntervalCounter
implements Counter {
    private static final double MILLIS_PER_SECOND = TimeUnit.SECONDS.toMillis(1L);
    private final Clock clock;
    private final Id id;
    private final Counter counter;
    private final AtomicLong lastUpdated;

    public static IntervalCounter get(Registry registry, Id id) {
        ConcurrentMap<Id, Object> state = registry.state();
        Object c = Utils.computeIfAbsent(state, id, i -> new IntervalCounter(registry, (Id)i));
        if (!(c instanceof IntervalCounter)) {
            Utils.propagateTypeError(registry, id, IntervalCounter.class, c.getClass());
            c = new IntervalCounter(new NoopRegistry(), id);
        }
        return (IntervalCounter)c;
    }

    IntervalCounter(Registry registry, Id id) {
        this.clock = registry.clock();
        this.id = id;
        this.counter = registry.counter(id.withTag(Statistic.count));
        this.lastUpdated = registry.gauge(id.withTag(Statistic.duration), new AtomicLong(0L), Functions.age(this.clock));
    }

    @Override
    public void increment() {
        this.counter.increment();
        this.lastUpdated.set(this.clock.wallTime());
    }

    @Override
    public void increment(long amount) {
        this.counter.increment(amount);
        this.lastUpdated.set(this.clock.wallTime());
    }

    @Override
    public long count() {
        return this.counter.count();
    }

    @Override
    public Id id() {
        return this.id;
    }

    public double secondsSinceLastUpdate() {
        long now = this.clock.wallTime();
        return (double)(now - this.lastUpdated.get()) / MILLIS_PER_SECOND;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }
}

