/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.AggrMeter;
import com.netflix.spectator.api.ArrayTagSet;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeCounter;
import com.netflix.spectator.api.CompositeDistributionSummary;
import com.netflix.spectator.api.CompositeGauge;
import com.netflix.spectator.api.CompositeMeter;
import com.netflix.spectator.api.CompositeTimer;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Gauge;
import com.netflix.spectator.api.GaugePoller;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.Utils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Semaphore;

public final class CompositeRegistry
implements Registry {
    private final Clock clock;
    private final CopyOnWriteArraySet<Registry> registries;
    private final ConcurrentHashMap<Id, AggrMeter> gauges;
    private final ConcurrentHashMap<Id, Object> state;
    private final Semaphore pollSem = new Semaphore(1);

    CompositeRegistry(Clock clock) {
        this.clock = clock;
        this.registries = new CopyOnWriteArraySet();
        this.gauges = new ConcurrentHashMap();
        this.state = new ConcurrentHashMap();
        GaugePoller.schedule(new WeakReference<Registry>(this), 10000L, CompositeRegistry::pollGauges);
    }

    private static void pollGauges(Registry r) {
        ((CompositeRegistry)r).pollGauges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollGauges() {
        if (this.pollSem.tryAcquire()) {
            try {
                for (Map.Entry<Id, AggrMeter> e : this.gauges.entrySet()) {
                    Id id = e.getKey();
                    Meter meter = e.getValue();
                    try {
                        if (meter.hasExpired()) continue;
                        for (Measurement m : meter.measure()) {
                            this.gauge(m.id()).set(m.value());
                        }
                    }
                    catch (StackOverflowError t) {
                        this.gauges.remove(id);
                    }
                    catch (ThreadDeath | VirtualMachineError t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        this.gauges.remove(id);
                    }
                }
            }
            finally {
                this.pollSem.release();
            }
        }
    }

    <T extends Registry> T find(Class<T> c) {
        for (Registry r : this.registries) {
            if (!c.isAssignableFrom(r.getClass())) continue;
            return (T)r;
        }
        return null;
    }

    public void add(Registry registry) {
        this.registries.add(registry);
    }

    public void remove(Registry registry) {
        this.registries.remove(registry);
    }

    public void removeAll() {
        this.registries.clear();
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Id createId(String name) {
        return new DefaultId(name);
    }

    @Override
    public Id createId(String name, Iterable<Tag> tags) {
        return new DefaultId(name, ArrayTagSet.create(tags));
    }

    @Override
    public void register(Meter meter) {
        AggrMeter m = Utils.computeIfAbsent(this.gauges, meter.id(), AggrMeter::new);
        m.add(meter);
    }

    @Override
    public ConcurrentMap<Id, Object> state() {
        return this.state;
    }

    @Override
    public Counter counter(Id id) {
        return new CompositeCounter(id, this.registries);
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        return new CompositeDistributionSummary(id, this.registries);
    }

    @Override
    public Timer timer(Id id) {
        return new CompositeTimer(id, this.clock, this.registries);
    }

    @Override
    public Gauge gauge(Id id) {
        return new CompositeGauge(id, this.registries);
    }

    @Override
    public Meter get(Id id) {
        return new CompositeMeter(id, this.registries);
    }

    @Override
    public Iterator<Meter> iterator() {
        if (this.registries.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        final HashSet<Id> ids = new HashSet<Id>();
        for (Registry r : this.registries) {
            for (Meter m : r) {
                ids.add(m.id());
            }
        }
        return new Iterator<Meter>(){
            private final Iterator<Id> idIter;
            {
                this.idIter = ids.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.idIter.hasNext();
            }

            @Override
            public Meter next() {
                return CompositeRegistry.this.get(this.idIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

