/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.impl.StepValue;
import java.util.concurrent.atomic.AtomicLong;

public class StepLong
implements StepValue {
    private final long init;
    private final Clock clock;
    private final long step;
    private final AtomicLong previous;
    private final AtomicLong current;
    private final AtomicLong lastInitPos;

    public StepLong(long init, Clock clock, long step) {
        this.init = init;
        this.clock = clock;
        this.step = step;
        this.previous = new AtomicLong(init);
        this.current = new AtomicLong(init);
        this.lastInitPos = new AtomicLong(clock.wallTime() / step);
    }

    private void rollCount(long now) {
        long stepTime = now / this.step;
        long lastInit = this.lastInitPos.get();
        if (lastInit < stepTime && this.lastInitPos.compareAndSet(lastInit, stepTime)) {
            long v = this.current.getAndSet(this.init);
            this.previous.set(lastInit == stepTime - 1L ? v : this.init);
        }
    }

    public AtomicLong getCurrent() {
        this.rollCount(this.clock.wallTime());
        return this.current;
    }

    public long poll() {
        this.rollCount(this.clock.wallTime());
        return this.previous.get();
    }

    @Override
    public double pollAsRate() {
        long amount = this.poll();
        double period = (double)this.step / 1000.0;
        return (double)amount / period;
    }

    @Override
    public long timestamp() {
        return this.lastInitPos.get() * this.step;
    }

    public String toString() {
        return "StepLong{init=" + this.init + ", previous=" + this.previous.get() + ", current=" + this.current.get() + ", lastInitPos=" + this.lastInitPos.get() + '}';
    }
}

