/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.impl.AtomicDouble;
import com.netflix.spectator.impl.StepValue;
import java.util.concurrent.atomic.AtomicLong;

public class StepDouble
implements StepValue {
    private final double init;
    private final Clock clock;
    private final long step;
    private final AtomicDouble previous;
    private final AtomicDouble current;
    private final AtomicLong lastInitPos;

    public StepDouble(double init, Clock clock, long step) {
        this.init = init;
        this.clock = clock;
        this.step = step;
        this.previous = new AtomicDouble(init);
        this.current = new AtomicDouble(init);
        this.lastInitPos = new AtomicLong(clock.wallTime() / step);
    }

    private void rollCount(long now) {
        long stepTime = now / this.step;
        long lastInit = this.lastInitPos.get();
        if (lastInit < stepTime && this.lastInitPos.compareAndSet(lastInit, stepTime)) {
            double v = this.current.getAndSet(this.init);
            this.previous.set(lastInit == stepTime - 1L ? v : this.init);
        }
    }

    public AtomicDouble getCurrent() {
        this.rollCount(this.clock.wallTime());
        return this.current;
    }

    public double poll() {
        this.rollCount(this.clock.wallTime());
        return this.previous.get();
    }

    @Override
    public double pollAsRate() {
        double amount = this.poll();
        double period = (double)this.step / 1000.0;
        return amount / period;
    }

    @Override
    public long timestamp() {
        return this.lastInitPos.get() * this.step;
    }

    public String toString() {
        return "StepLong{init=" + this.init + ", previous=" + this.previous.get() + ", current=" + this.current.get() + ", lastInitPos=" + this.lastInitPos.get() + '}';
    }
}

