/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.histogram.PercentileBuckets;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class PercentileTimer
implements Timer {
    private final Registry registry;
    private final Id id;
    private final Timer timer;
    private final Counter[] counters;

    public static PercentileTimer get(Registry registry, Id id) {
        return new PercentileTimer(registry, id);
    }

    PercentileTimer(Registry registry, Id id) {
        this.registry = registry;
        this.id = id;
        this.timer = registry.timer(id);
        this.counters = new Counter[PercentileBuckets.length()];
        for (int i = 0; i < this.counters.length; ++i) {
            Id counterId = id.withTag("percentile", String.format("T%04X", i));
            this.counters[i] = registry.counter(counterId);
        }
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return this.timer.hasExpired();
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        long nanos = unit.toNanos(amount);
        this.timer.record(amount, unit);
        this.counters[PercentileBuckets.indexOf(nanos)].increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> rf) throws Exception {
        Clock clock = this.registry.clock();
        long s = clock.monotonicTime();
        try {
            T t = rf.call();
            return t;
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable rf) {
        Clock clock = this.registry.clock();
        long s = clock.monotonicTime();
        try {
            rf.run();
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    public double percentile(double p) {
        long[] counts = new long[PercentileBuckets.length()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = this.counters[i].count();
        }
        double v = PercentileBuckets.percentile(counts, p);
        return v / 1.0E9;
    }

    @Override
    public long count() {
        return this.timer.count();
    }

    @Override
    public long totalTime() {
        return this.timer.totalTime();
    }
}

