/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

final class ArrayTagSet
implements Iterable<Tag> {
    private static final Comparator<Tag> TAG_COMPARATOR = (t1, t2) -> t1.key().compareTo(t2.key());
    static final ArrayTagSet EMPTY = new ArrayTagSet(new Tag[0]);
    private final Tag[] tags;
    private final int length;

    static ArrayTagSet create(String ... tags) {
        return EMPTY.addAll(tags);
    }

    static ArrayTagSet create(Tag ... tags) {
        return EMPTY.addAll(tags);
    }

    static ArrayTagSet create(Iterable<Tag> tags) {
        return EMPTY.addAll(tags);
    }

    static ArrayTagSet create(Map<String, String> tags) {
        return EMPTY.addAll(tags);
    }

    private ArrayTagSet(Tag[] tags) {
        this(tags, tags.length);
    }

    private ArrayTagSet(Tag[] tags, int length) {
        if (length > tags.length) {
            throw new IllegalArgumentException("length cannot be larger than tags array");
        }
        this.tags = tags;
        this.length = length;
    }

    @Override
    public Iterator<Tag> iterator() {
        return new Iterator<Tag>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ArrayTagSet.this.length;
            }

            @Override
            public Tag next() {
                if (this.i >= ArrayTagSet.this.length) {
                    throw new NoSuchElementException("next called after end of iterator");
                }
                return ArrayTagSet.this.tags[this.i++];
            }
        };
    }

    boolean isEmpty() {
        return this.length == 0;
    }

    ArrayTagSet add(String k, String v) {
        return this.add(new BasicTag(k, v));
    }

    ArrayTagSet add(Tag tag) {
        Tag[] newTags;
        int pos = Arrays.binarySearch(this.tags, 0, this.length, tag, TAG_COMPARATOR);
        if (pos < 0) {
            newTags = new Tag[this.length + 1];
            int i = -pos - 1;
            if (i == 0) {
                System.arraycopy(this.tags, 0, newTags, 1, this.length);
            } else if (i == this.length) {
                System.arraycopy(this.tags, 0, newTags, 0, this.length);
            } else {
                System.arraycopy(this.tags, 0, newTags, 0, i);
                System.arraycopy(this.tags, i, newTags, i + 1, this.length - i);
            }
            newTags[i] = BasicTag.convert(tag);
        } else {
            newTags = new Tag[this.length];
            System.arraycopy(this.tags, 0, newTags, 0, this.length);
            newTags[pos] = BasicTag.convert(tag);
        }
        return new ArrayTagSet(newTags);
    }

    ArrayTagSet addAll(Iterable<Tag> ts) {
        if (ts instanceof ArrayTagSet) {
            ArrayTagSet data = (ArrayTagSet)ts;
            return this.addAll(data.tags, data.length);
        }
        if (ts instanceof Collection) {
            Collection data = (Collection)ts;
            if (data.isEmpty()) {
                return this;
            }
            Tag[] newTags = new Tag[this.length + data.size()];
            System.arraycopy(this.tags, 0, newTags, 0, this.length);
            int i = 0;
            for (Tag t : data) {
                newTags[this.length + i] = BasicTag.convert(t);
                ++i;
            }
            return this.dedup(newTags);
        }
        ArrayList<Tag> data = new ArrayList<Tag>();
        for (Tag t : ts) {
            data.add(t);
        }
        return this.addAll(data);
    }

    ArrayTagSet addAll(Map<String, String> ts) {
        if (ts.isEmpty()) {
            return this;
        }
        Tag[] newTags = new Tag[this.length + ts.size()];
        System.arraycopy(this.tags, 0, newTags, 0, this.length);
        int i = this.length;
        for (Map.Entry<String, String> entry : ts.entrySet()) {
            newTags[i++] = new BasicTag(entry.getKey(), entry.getValue());
        }
        return this.dedup(newTags);
    }

    ArrayTagSet addAll(String[] ts) {
        if (ts.length == 0) {
            return this;
        }
        int tsLength = ts.length / 2;
        Tag[] newTags = new Tag[this.length + tsLength];
        System.arraycopy(this.tags, 0, newTags, 0, this.length);
        for (int i = 0; i < tsLength; ++i) {
            newTags[this.length + i] = new BasicTag(ts[i], ts[i + 1]);
        }
        return this.dedup(newTags);
    }

    ArrayTagSet addAll(Tag[] ts) {
        return this.addAll(ts, ts.length);
    }

    ArrayTagSet addAll(Tag[] ts, int tsLength) {
        if (tsLength == 0) {
            return this;
        }
        Tag[] newTags = new Tag[this.length + tsLength];
        System.arraycopy(this.tags, 0, newTags, 0, this.length);
        for (int i = 0; i < tsLength; ++i) {
            newTags[this.length + i] = BasicTag.convert(ts[i]);
        }
        return this.dedup(newTags);
    }

    private ArrayTagSet dedup(Tag[] ts) {
        Arrays.sort(ts, TAG_COMPARATOR);
        String k = ts[0].key();
        int j = 0;
        for (int i = 0; i < ts.length; ++i) {
            if (k.equals(ts[i].key())) {
                ts[j] = ts[i];
                continue;
            }
            k = ts[i].key();
            ts[++j] = ts[i];
        }
        return new ArrayTagSet(ts, j + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayTagSet other = (ArrayTagSet)o;
        if (this.length != other.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.tags[i].equals(other.tags[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.length;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + this.tags[i].hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            builder.append(':').append(this.tags[i].key()).append('=').append(this.tags[i].value());
        }
        return builder.toString();
    }
}

