/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;

public final class BucketFunctions {
    static final List<ValueFormatter> FORMATTERS = new ArrayList<ValueFormatter>();

    private static ValueFormatter fmt(long max, int width, String suffix, TimeUnit unit) {
        return new ValueFormatter(max, width, suffix, unit);
    }

    private BucketFunctions() {
    }

    private static ValueFormatter getFormatter(long max) {
        for (ValueFormatter f : FORMATTERS) {
            if (max >= f.max) continue;
            return f;
        }
        return new ValueFormatter(max, ("" + max).length(), "ns", TimeUnit.NANOSECONDS);
    }

    private static LongFunction<String> timeBiasZero(String ltZero, String gtMax, long max, TimeUnit unit) {
        long nanos = unit.toNanos(max);
        ValueFormatter f = BucketFunctions.getFormatter(nanos);
        long v = f.unit().convert(max, unit);
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        buckets.add(new Bucket(ltZero, 0L));
        buckets.add(f.newBucket(v / 8L));
        buckets.add(f.newBucket(v / 4L));
        buckets.add(f.newBucket(v / 2L));
        buckets.add(f.newBucket(v));
        return new ListBucketFunction(buckets, gtMax);
    }

    private static LongFunction<String> timeBiasMax(String ltZero, String gtMax, long max, TimeUnit unit) {
        long nanos = unit.toNanos(max);
        ValueFormatter f = BucketFunctions.getFormatter(nanos);
        long v = f.unit().convert(max, unit);
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        buckets.add(new Bucket(ltZero, 0L));
        buckets.add(f.newBucket(v - v / 2L));
        buckets.add(f.newBucket(v - v / 4L));
        buckets.add(f.newBucket(v - v / 8L));
        buckets.add(f.newBucket(v));
        return new ListBucketFunction(buckets, gtMax);
    }

    public static LongFunction<String> age(long max, TimeUnit unit) {
        return BucketFunctions.timeBiasZero("future", "old", max, unit);
    }

    public static LongFunction<String> latency(long max, TimeUnit unit) {
        return BucketFunctions.timeBiasZero("negative_latency", "slow", max, unit);
    }

    public static LongFunction<String> ageBiasOld(long max, TimeUnit unit) {
        return BucketFunctions.timeBiasMax("future", "old", max, unit);
    }

    public static LongFunction<String> latencyBiasSlow(long max, TimeUnit unit) {
        return BucketFunctions.timeBiasMax("negative_latency", "slow", max, unit);
    }

    static {
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.NANOSECONDS.toNanos(10L), 1, "ns", TimeUnit.NANOSECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.NANOSECONDS.toNanos(100L), 2, "ns", TimeUnit.NANOSECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MICROSECONDS.toNanos(1L), 3, "ns", TimeUnit.NANOSECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MICROSECONDS.toNanos(8L), 4, "ns", TimeUnit.NANOSECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MICROSECONDS.toNanos(10L), 1, "us", TimeUnit.MICROSECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MICROSECONDS.toNanos(100L), 2, "us", TimeUnit.MICROSECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MILLISECONDS.toNanos(1L), 3, "us", TimeUnit.MICROSECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MILLISECONDS.toNanos(8L), 4, "us", TimeUnit.MICROSECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MILLISECONDS.toNanos(10L), 1, "ms", TimeUnit.MILLISECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MILLISECONDS.toNanos(100L), 2, "ms", TimeUnit.MILLISECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.SECONDS.toNanos(1L), 3, "ms", TimeUnit.MILLISECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.SECONDS.toNanos(8L), 4, "ms", TimeUnit.MILLISECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.SECONDS.toNanos(10L), 1, "s", TimeUnit.SECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.SECONDS.toNanos(100L), 2, "s", TimeUnit.SECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MINUTES.toNanos(8L), 3, "s", TimeUnit.SECONDS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MINUTES.toNanos(10L), 1, "min", TimeUnit.MINUTES));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.MINUTES.toNanos(100L), 2, "min", TimeUnit.MINUTES));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.HOURS.toNanos(8L), 3, "min", TimeUnit.MINUTES));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.HOURS.toNanos(10L), 1, "h", TimeUnit.HOURS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.HOURS.toNanos(100L), 2, "h", TimeUnit.HOURS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(8L), 1, "h", TimeUnit.HOURS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(10L), 1, "d", TimeUnit.DAYS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(100L), 2, "d", TimeUnit.DAYS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(1000L), 3, "d", TimeUnit.DAYS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(10000L), 4, "d", TimeUnit.DAYS));
        FORMATTERS.add(BucketFunctions.fmt(TimeUnit.DAYS.toNanos(100000L), 5, "d", TimeUnit.DAYS));
        FORMATTERS.add(BucketFunctions.fmt(Long.MAX_VALUE, 6, "d", TimeUnit.DAYS));
    }

    private static class Bucket {
        private final String name;
        private final long upperBoundary;

        Bucket(String name, long upperBoundary) {
            this.name = name;
            this.upperBoundary = upperBoundary;
        }

        String name() {
            return this.name;
        }

        long upperBoundary() {
            return this.upperBoundary;
        }

        public String toString() {
            return String.format("Bucket(%s,%d)", this.name, this.upperBoundary);
        }
    }

    private static class ListBucketFunction
    implements LongFunction<String> {
        private final List<Bucket> buckets;
        private final String fallback;

        ListBucketFunction(List<Bucket> buckets, String fallback) {
            this.buckets = buckets;
            this.fallback = fallback;
        }

        @Override
        public String apply(long amount) {
            for (Bucket b : this.buckets) {
                if (amount >= b.upperBoundary) continue;
                return b.name();
            }
            return this.fallback;
        }
    }

    static class ValueFormatter {
        private final long max;
        private final String fmt;
        private final TimeUnit unit;

        ValueFormatter(long max, int width, String suffix, TimeUnit unit) {
            this.max = max;
            this.fmt = "%0" + width + "d" + suffix;
            this.unit = unit;
        }

        long max() {
            return this.max;
        }

        TimeUnit unit() {
            return this.unit;
        }

        String apply(long v) {
            return String.format(this.fmt, this.unit.convert(v, TimeUnit.NANOSECONDS));
        }

        Bucket newBucket(long v) {
            long nanos = this.unit.toNanos(v);
            return new Bucket(this.apply(nanos), nanos);
        }
    }
}

