/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.CompositeRegistry;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DefaultLongTaskTimer;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Functions;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.LongTaskTimer;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.ObjectGauge;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.api.Throwables;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.ValueFunction;
import com.netflix.spectator.impl.Preconditions;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtendedRegistry
implements Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedRegistry.class);
    private final Registry impl;

    public ExtendedRegistry(Registry impl) {
        this.impl = Preconditions.checkNotNull(impl, "impl");
    }

    public Registry underlying() {
        return this.impl;
    }

    public <T extends Registry> T underlying(Class<T> c) {
        if (c.isAssignableFrom(this.impl.getClass())) {
            return (T)this.impl;
        }
        if (this.impl instanceof CompositeRegistry) {
            return ((CompositeRegistry)this.impl).find(c);
        }
        return null;
    }

    @Override
    public Clock clock() {
        return this.impl.clock();
    }

    @Override
    public Id createId(String name) {
        return this.impl.createId(name);
    }

    @Override
    public Id createId(String name, Iterable<Tag> tags) {
        return this.impl.createId(name, tags);
    }

    @Override
    public void register(Meter meter) {
        this.impl.register(meter);
    }

    @Override
    public Counter counter(Id id) {
        return this.impl.counter(id);
    }

    @Override
    public DistributionSummary distributionSummary(Id id) {
        return this.impl.distributionSummary(id);
    }

    @Override
    public Timer timer(Id id) {
        return this.impl.timer(id);
    }

    @Override
    public Meter get(Id id) {
        return this.impl.get(id);
    }

    @Override
    public Iterator<Meter> iterator() {
        return this.impl.iterator();
    }

    private Iterable<Tag> toIterable(String[] tags) {
        if (tags.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        TagList ts = TagList.EMPTY;
        for (int i = 0; i < tags.length; i += 2) {
            ts = new TagList(tags[i], tags[i + 1], ts);
        }
        return ts;
    }

    public Id createId(String name, String ... tags) {
        return this.impl.createId(name, this.toIterable(tags));
    }

    public Id createId(String name, Map<String, String> tags) {
        return this.impl.createId(name).withTags(TagList.create(tags));
    }

    public Counter counter(String name) {
        return this.impl.counter(this.impl.createId(name));
    }

    public Counter counter(String name, Iterable<Tag> tags) {
        return this.impl.counter(this.impl.createId(name, tags));
    }

    public Counter counter(String name, String ... tags) {
        return this.impl.counter(this.impl.createId(name, this.toIterable(tags)));
    }

    public DistributionSummary distributionSummary(String name) {
        return this.impl.distributionSummary(this.impl.createId(name));
    }

    public DistributionSummary distributionSummary(String name, Iterable<Tag> tags) {
        return this.impl.distributionSummary(this.impl.createId(name, tags));
    }

    public DistributionSummary distributionSummary(String name, String ... tags) {
        return this.impl.distributionSummary(this.impl.createId(name, this.toIterable(tags)));
    }

    public Timer timer(String name) {
        return this.impl.timer(this.impl.createId(name));
    }

    public Timer timer(String name, Iterable<Tag> tags) {
        return this.impl.timer(this.impl.createId(name, tags));
    }

    public Timer timer(String name, String ... tags) {
        return this.impl.timer(this.impl.createId(name, this.toIterable(tags)));
    }

    public LongTaskTimer longTaskTimer(Id id) {
        DefaultLongTaskTimer taskTimer = new DefaultLongTaskTimer(this.clock(), id);
        this.impl.register(taskTimer);
        return taskTimer;
    }

    public LongTaskTimer longTaskTimer(String name) {
        return this.longTaskTimer(this.createId(name));
    }

    public LongTaskTimer longTaskTimer(String name, Iterable<Tag> tags) {
        return this.longTaskTimer(this.createId(name, tags));
    }

    public LongTaskTimer longTaskTimer(String name, String ... tags) {
        return this.longTaskTimer(this.createId(name, this.toIterable(tags)));
    }

    public <T extends Number> T gauge(Id id, T number) {
        return this.gauge(id, number, (ValueFunction)Functions.IDENTITY);
    }

    public <T extends Number> T gauge(String name, T number) {
        return this.gauge(this.impl.createId(name), number);
    }

    public <T extends Number> T gauge(String name, Iterable<Tag> tags, T number) {
        return this.gauge(this.impl.createId(name, tags), number);
    }

    public <T> T gauge(Id id, T obj, ValueFunction f) {
        this.impl.register(new ObjectGauge(this.clock(), id, obj, f));
        return obj;
    }

    public <T> T gauge(String name, T obj, ValueFunction f) {
        return this.gauge(this.impl.createId(name), obj, f);
    }

    public <T extends Collection<?>> T collectionSize(Id id, T collection) {
        return this.gauge(id, collection, Functions.COLLECTION_SIZE);
    }

    public <T extends Collection<?>> T collectionSize(String name, T collection) {
        return this.collectionSize(this.impl.createId(name), collection);
    }

    public <T extends Map<?, ?>> T mapSize(Id id, T collection) {
        return this.gauge(id, collection, Functions.MAP_SIZE);
    }

    public <T extends Map<?, ?>> T mapSize(String name, T collection) {
        return this.mapSize(this.impl.createId(name), collection);
    }

    public void methodValue(Id id, Object obj, String method) {
        try {
            Method m = this.getMethod(obj.getClass(), method);
            try {
                Number n = (Number)m.invoke(obj, new Object[0]);
                LOGGER.debug("registering gauge {}, using method [{}], with initial value {}", new Object[]{id, m, n});
                this.gauge(id, obj, Functions.invokeMethod(m));
            }
            catch (Exception e) {
                String msg = "exception thrown invoking method [" + m + "], skipping registration of gauge " + id;
                Throwables.propagate(msg, e);
            }
        }
        catch (NoSuchMethodException e) {
            String mname = obj.getClass().getName() + "." + method;
            String msg = "invalid method [" + mname + "], skipping registration of gauge " + id;
            Throwables.propagate(msg, e);
        }
    }

    public void methodValue(String name, Object obj, String method) {
        this.methodValue(this.impl.createId(name), obj, method);
    }

    Method getMethod(Class<?> cls, String name) throws NoSuchMethodException {
        NoSuchMethodException firstExc = null;
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            try {
                return c.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (firstExc != null) continue;
                firstExc = e;
                continue;
            }
        }
        throw firstExc;
    }

    public String toString() {
        return "ExtendedRegistry(impl=" + this.impl + ')';
    }
}

