/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.ConfigMap;
import com.netflix.spectator.api.Spectator;
import com.netflix.spectator.api.SystemConfigMap;

final class Config {
    private static final String PREFIX = "spectator.api.";
    static final String SERVICE_LOADER = "service-loader";

    private Config() {
    }

    private static String get(String k) {
        ConfigMap cfg = Spectator.config();
        if (cfg == null) {
            cfg = new SystemConfigMap();
        }
        return cfg.get(k);
    }

    private static String get(String k, String dflt) {
        String v = Config.get(k);
        return v == null ? dflt : v;
    }

    static boolean propagateWarnings() {
        return Boolean.valueOf(Config.get("spectator.api.propagateWarnings", "false"));
    }

    static String registryClass() {
        return Config.get("spectator.api.registryClass", SERVICE_LOADER);
    }

    static int maxNumberOfMeters() {
        String v = Config.get("spectator.api.maxNumberOfMeters");
        return v == null ? Integer.MAX_VALUE : Integer.parseInt(v);
    }
}

