/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.ArrayTagSet;
import com.netflix.spectator.api.DefaultId;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.TagList;
import com.netflix.spectator.api.Utils;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public interface Id
extends TagList {
    public String name();

    public Iterable<Tag> tags();

    public Id withTag(String var1, String var2);

    public Id withTag(Tag var1);

    default public Id withTag(String k, boolean v) {
        return this.withTag(k, Boolean.toString(v));
    }

    default public <E extends Enum<E>> Id withTag(String k, Enum<E> v) {
        return this.withTag(k, v.name());
    }

    default public Id withTags(String k1, String v1) {
        return this.withTag(k1, v1);
    }

    default public Id withTags(String k1, String v1, String k2, String v2) {
        String[] ts = new String[]{k1, v1, k2, v2};
        return this.withTags(ts);
    }

    default public Id withTags(String k1, String v1, String k2, String v2, String k3, String v3) {
        String[] ts = new String[]{k1, v1, k2, v2, k3, v3};
        return this.withTags(ts);
    }

    default public Id withTags(String ... tags) {
        Id tmp = this;
        for (int i = 0; i < tags.length; i += 2) {
            tmp = tmp.withTag(tags[i], tags[i + 1]);
        }
        return tmp;
    }

    default public Id withTags(Tag ... tags) {
        Id tmp = this;
        for (Tag t : tags) {
            tmp = tmp.withTag(t);
        }
        return tmp;
    }

    default public Id withTags(Iterable<Tag> tags) {
        Id tmp = this;
        for (Tag t : tags) {
            tmp = tmp.withTag(t);
        }
        return tmp;
    }

    default public Id withTags(Map<String, String> tags) {
        Id tmp = this;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            tmp = tmp.withTag(entry.getKey(), entry.getValue());
        }
        return tmp;
    }

    @Override
    default public String getKey(int i) {
        return i == 0 ? "name" : Utils.getValue(this.tags(), i - 1).key();
    }

    @Override
    default public String getValue(int i) {
        return i == 0 ? this.name() : Utils.getValue(this.tags(), i - 1).value();
    }

    @Override
    default public int size() {
        return Utils.size(this.tags()) + 1;
    }

    @Override
    default public Id filter(BiPredicate<String, String> predicate) {
        ArrayList<Tag> filtered = new ArrayList<Tag>();
        for (Tag tag : this.tags()) {
            if (!predicate.test(tag.key(), tag.value())) continue;
            filtered.add(tag);
        }
        return new DefaultId(this.name(), ArrayTagSet.create(filtered));
    }

    @Override
    default public Id filterByKey(Predicate<String> predicate) {
        return this.filter((k, v) -> predicate.test((String)k));
    }

    public static Id create(String name) {
        return new DefaultId(name);
    }
}

