/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.api;

import spectator-agent.spectator.api.DistributionSummary;

class DistSummaryBatchUpdater
implements DistributionSummary.BatchUpdater {
    private final DistributionSummary distSummary;
    private final int batchSize;
    private int count;
    private final long[] amounts;

    DistSummaryBatchUpdater(DistributionSummary distSummary, int batchSize) {
        this.distSummary = distSummary;
        this.batchSize = batchSize;
        this.count = 0;
        this.amounts = new long[batchSize];
    }

    @Override
    public void record(long amount) {
        if (amount >= 0L) {
            this.amounts[this.count++] = amount;
            if (this.count >= this.batchSize) {
                this.flush();
            }
        }
    }

    @Override
    public void flush() {
        this.distSummary.record(this.amounts, this.count);
        this.count = 0;
    }

    @Override
    public void close() throws Exception {
        this.flush();
    }
}

