/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.atlas.Rollups;
import spectator-agent.spectator.impl.Preconditions;

public interface RollupPolicy
extends Function<List<Measurement>, List<Result>> {
    public static RollupPolicy noop(Map<String, String> commonTags) {
        return ms -> Collections.singletonList(new Result(commonTags, (List<Measurement>)ms));
    }

    public static RollupPolicy fromIdMapper(Map<String, String> commonTags, Function<Id, Id> idMapper) {
        Function<Id, Id> mapper = commonTags.isEmpty() ? idMapper : id -> (Id)idMapper.apply(id.withTags(commonTags));
        return ms -> Collections.singletonList(new Result(Rollups.aggregate(mapper, ms)));
    }

    public static RollupPolicy fromRules(Map<String, String> commonTags, List<Rule> rules) {
        return Rollups.fromRules(commonTags, rules);
    }

    public static final class Result {
        private final Map<String, String> commonTags;
        private final List<Measurement> measurements;

        public Result(List<Measurement> measurements) {
            this(Collections.emptyMap(), measurements);
        }

        public Result(Map<String, String> commonTags, List<Measurement> measurements) {
            this.commonTags = commonTags;
            this.measurements = measurements;
        }

        public Map<String, String> commonTags() {
            return this.commonTags;
        }

        public List<Measurement> measurements() {
            return this.measurements;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result result = (Result)o;
            return this.commonTags.equals(result.commonTags) && this.measurements.equals(result.measurements);
        }

        public int hashCode() {
            return Objects.hash(this.commonTags, this.measurements);
        }
    }

    public static final class Rule {
        private final String query;
        private final List<String> rollup;

        public Rule(String query, List<String> rollup) {
            this.query = Preconditions.checkNotNull(query, "query");
            this.rollup = Preconditions.checkNotNull(rollup, "rollup");
        }

        public String query() {
            return this.query;
        }

        public List<String> rollup() {
            return this.rollup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Rule)) {
                return false;
            }
            Rule rule = (Rule)o;
            return this.query.equals(rule.query) && this.rollup.equals(rule.rollup);
        }

        public int hashCode() {
            return Objects.hash(this.query, this.rollup);
        }
    }
}

