/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import spectator-agent.slf4j.Logger;
import spectator-agent.slf4j.LoggerFactory;
import spectator-agent.spectator.api.NoopRegistry;
import spectator-agent.spectator.api.Registry;
import spectator-agent.spectator.atlas.AtlasConfig;
import spectator-agent.spectator.atlas.AtlasRegistry;
import spectator-agent.spectator.atlas.Publisher;
import spectator-agent.spectator.atlas.impl.EvalPayload;
import spectator-agent.spectator.atlas.impl.GzipLevelOutputStream;
import spectator-agent.spectator.atlas.impl.JsonUtils;
import spectator-agent.spectator.atlas.impl.PublishPayload;
import spectator-agent.spectator.atlas.impl.StreamHelper;
import spectator-agent.spectator.atlas.impl.ValidationHelper;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.core.JsonFactory;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.databind.ObjectMapper;
import spectator-agent.spectator.atlas.shaded.spectator-atlas.json.dataformat.smile.SmileFactory;
import spectator-agent.spectator.ipc.http.HttpClient;
import spectator-agent.spectator.ipc.http.HttpResponse;

public final class DefaultPublisher
implements Publisher {
    private static final String CLOCK_SKEW_TIMER = "spectator.atlas.clockSkew";
    private final Logger logger = LoggerFactory.getLogger(AtlasRegistry.class);
    private final StreamHelper streamHelper = new StreamHelper();
    private final URI uri;
    private final URI evalUri;
    private final int connectTimeout;
    private final int readTimeout;
    private final int numThreads;
    private final Registry debugRegistry;
    private final HttpClient client;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final ValidationHelper validationHelper;
    private ExecutorService senderPool;

    public DefaultPublisher(AtlasConfig config) {
        this(config, null);
    }

    public DefaultPublisher(AtlasConfig config, HttpClient client) {
        this.uri = URI.create(config.uri());
        this.evalUri = URI.create(config.evalUri());
        this.connectTimeout = (int)config.connectTimeout().toMillis();
        this.readTimeout = (int)config.readTimeout().toMillis();
        this.numThreads = config.numThreads();
        this.debugRegistry = Optional.ofNullable(config.debugRegistry()).orElse(new NoopRegistry());
        this.client = client != null ? client : HttpClient.create(this.debugRegistry);
        Function<String, String> replacementFunc = JsonUtils.createReplacementFunction(config.validTagCharacters());
        this.jsonMapper = JsonUtils.createMapper(new JsonFactory(), replacementFunc);
        this.smileMapper = JsonUtils.createMapper(new SmileFactory(), replacementFunc);
        this.validationHelper = new ValidationHelper(this.logger, this.jsonMapper, this.debugRegistry);
    }

    @Override
    public void init() {
        ThreadFactory factory = new ThreadFactory(){
            private final AtomicInteger next = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                String name = "spectator-atlas-publish-" + this.next.getAndIncrement();
                Thread t = new Thread(r, name);
                t.setDaemon(true);
                return t;
            }
        };
        this.senderPool = Executors.newFixedThreadPool(this.numThreads, factory);
    }

    private byte[] encodeBatch(PublishPayload payload) throws IOException {
        ByteArrayOutputStream baos = this.streamHelper.getOrCreateStream();
        try (GzipLevelOutputStream out = new GzipLevelOutputStream(baos);){
            this.smileMapper.writeValue(out, (Object)payload);
        }
        return baos.toByteArray();
    }

    private void recordClockSkew(long responseTimestamp) {
        if (responseTimestamp == 0L) {
            this.logger.debug("no date timestamp on response, cannot record skew");
        } else {
            long delta = this.debugRegistry.clock().wallTime() - responseTimestamp;
            if (delta >= 0L) {
                this.debugRegistry.timer(CLOCK_SKEW_TIMER, "id", "fast").record(delta, TimeUnit.MILLISECONDS);
            } else {
                this.debugRegistry.timer(CLOCK_SKEW_TIMER, "id", "slow").record(-delta, TimeUnit.MILLISECONDS);
            }
            this.logger.debug("clock skew between client and server: {}ms", (Object)delta);
        }
    }

    @Override
    public CompletableFuture<Void> publish(PublishPayload payload) {
        Runnable task = () -> {
            try {
                HttpResponse res;
                Instant date;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("publish payload: {}", (Object)this.jsonMapper.writeValueAsString(payload));
                }
                this.recordClockSkew((date = (res = this.client.post(this.uri).withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).addHeader("Content-Encoding", "gzip").withContent("application/x-jackson-smile", this.encodeBatch(payload)).send()).dateHeader("Date")) == null ? 0L : date.toEpochMilli());
                this.validationHelper.recordResults(payload.getMetrics().size(), res);
            }
            catch (Exception e) {
                this.logger.warn("failed to send metrics (uri={})", (Object)this.uri, (Object)e);
                this.validationHelper.incrementDroppedHttp(payload.getMetrics().size());
            }
        };
        return CompletableFuture.runAsync(task, this.senderPool);
    }

    @Override
    public CompletableFuture<Void> publish(EvalPayload payload) {
        Runnable task = () -> {
            try {
                String json = this.jsonMapper.writeValueAsString(payload);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("eval payload: {}", (Object)json);
                }
                this.client.post(this.evalUri).withConnectTimeout(this.connectTimeout).withReadTimeout(this.readTimeout).withJsonContent(json).send();
            }
            catch (Exception e) {
                this.logger.warn("failed to send metrics for subscriptions (uri={})", (Object)this.evalUri, (Object)e);
            }
        };
        return CompletableFuture.runAsync(task, this.senderPool);
    }

    @Override
    public void close() throws IOException {
        if (this.senderPool != null) {
            this.senderPool.shutdown();
            this.senderPool = null;
        }
    }
}

