/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.iep;

import com.netflix.iep.config.ConfigManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class NetflixEnvironment {
    private static final String NAMESPACE = "netflix.iep.env.";
    private static final Set DEFAULT_ATLAS_TAG_KEYS;

    private NetflixEnvironment() {
    }

    public static String ami() {
        return ConfigManager.get().getString("netflix.iep.env.ami");
    }

    public static String vmtype() {
        return ConfigManager.get().getString("netflix.iep.env.vmtype");
    }

    public static String vpcId() {
        return ConfigManager.get().getString("netflix.iep.env.vpc-id");
    }

    public static String region() {
        return ConfigManager.get().getString("netflix.iep.env.region");
    }

    public static String zone() {
        return ConfigManager.get().getString("netflix.iep.env.zone");
    }

    public static String instanceId() {
        return ConfigManager.get().getString("netflix.iep.env.instance-id");
    }

    public static String app() {
        return ConfigManager.get().getString("netflix.iep.env.app");
    }

    public static String cluster() {
        return ConfigManager.get().getString("netflix.iep.env.cluster");
    }

    public static String asg() {
        return ConfigManager.get().getString("netflix.iep.env.asg");
    }

    public static String stack() {
        return ConfigManager.get().getString("netflix.iep.env.stack");
    }

    public static String env() {
        return ConfigManager.get().getString("netflix.iep.env.environment");
    }

    public static String accountId() {
        return ConfigManager.get().getString("netflix.iep.env.account-id");
    }

    public static String accountName() {
        return ConfigManager.get().getString("netflix.iep.env.account");
    }

    public static String accountType() {
        return ConfigManager.get().getString("netflix.iep.env.account-type");
    }

    public static String accountEnv() {
        return ConfigManager.get().getString("netflix.iep.env.account-env");
    }

    public static String insightAccountId() {
        return ConfigManager.get().getString("netflix.iep.env.insight-account-id");
    }

    public static Map<String, String> commonTags() {
        return NetflixEnvironment.commonTags(System::getenv);
    }

    public static Map<String, String> commonTags(Function<String, String> function) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.account", "NETFLIX_ACCOUNT_ID", "EC2_OWNER_ID");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.ami", "EC2_AMI_ID");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.app", "NETFLIX_APP");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.asg", "NETFLIX_AUTO_SCALE_GROUP");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.cluster", "NETFLIX_CLUSTER");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.node", "NETFLIX_INSTANCE_ID", "TITUS_TASK_INSTANCE_ID", "EC2_INSTANCE_ID");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.region", "NETFLIX_REGION", "EC2_REGION");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.shard1", "NETFLIX_SHARD1");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.shard2", "NETFLIX_SHARD2");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.stack", "NETFLIX_STACK");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.vmtype", "EC2_INSTANCE_TYPE");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "nf.zone", "EC2_AVAILABILITY_ZONE");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "process", "NETFLIX_PROCESS_NAME");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "accountType", "NETFLIX_ACCOUNT_TYPE");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "buildUrl", "NETFLIX_BUILD_JOB");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "sourceRepo", "NETFLIX_BUILD_SOURCE_REPO");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "branch", "NETFLIX_BUILD_BRANCH");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "commit", "NETFLIX_BUILD_COMMIT");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "mantisJobName", "MANTIS_JOB_NAME");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "mantisJobId", "MANTIS_JOB_ID");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "mantisWorkerIndex", "MANTIS_WORKER_INDEX");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "mantisWorkerNumber", "MANTIS_WORKER_NUMBER");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "mantisWorkerStageNumber", "MANTIS_WORKER_STAGE_NUMBER");
        NetflixEnvironment.putIfNotEmptyOrNull(function, hashMap, "mantisUser", "MANTIS_USER");
        return hashMap;
    }

    public static Map<String, String> commonTagsForAtlas() {
        return NetflixEnvironment.commonTagsForAtlas(System::getenv);
    }

    public static Map<String, String> commonTagsForAtlas(Function<String, String> function) {
        return NetflixEnvironment.commonTagsForAtlas(function, NetflixEnvironment.defaultAtlasKeyPredicate(function));
    }

    public static Map<String, String> commonTagsForAtlas(Function<String, String> function, Predicate<String> predicate) {
        Map<String, String> map = NetflixEnvironment.commonTags(function);
        map.keySet().removeIf(predicate.negate());
        return map;
    }

    public static Predicate<String> defaultAtlasKeyPredicate(Function<String, String> function) {
        Predicate<String> predicate = NetflixEnvironment.atlasSkipTagsPredicate(function);
        return string -> DEFAULT_ATLAS_TAG_KEYS.contains(string) && predicate.test((String)string);
    }

    public static Predicate<String> atlasSkipTagsPredicate(Function<String, String> function) {
        Set<String> set = NetflixEnvironment.parseAtlasSkipTags(function);
        return string -> !set.contains(string);
    }

    private static boolean isEmptyOrNull(String string) {
        return string == null || string.trim().isEmpty();
    }

    private static void putIfNotEmptyOrNull(Function<String, String> function, Map<String, String> map, String string, String ... stringArray) {
        for (String string2 : stringArray) {
            String string3 = function.apply(string2);
            if (NetflixEnvironment.isEmptyOrNull(string3)) continue;
            map.put(string, string3.trim());
            break;
        }
    }

    private static Set<String> parseAtlasSkipTags(Function<String, String> function) {
        return NetflixEnvironment.parseAtlasSkipTags(function.apply("ATLAS_SKIP_COMMON_TAGS"));
    }

    private static Set<String> parseAtlasSkipTags(String string) {
        String[] stringArray;
        if (NetflixEnvironment.isEmptyOrNull(string)) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray = string.split(",")) {
            if (NetflixEnvironment.isEmptyOrNull(string2)) continue;
            hashSet.add(string2.trim());
        }
        return hashSet;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("nf.account");
        hashSet.add("nf.app");
        hashSet.add("nf.asg");
        hashSet.add("nf.cluster");
        hashSet.add("nf.node");
        hashSet.add("nf.region");
        hashSet.add("nf.shard1");
        hashSet.add("nf.shard2");
        hashSet.add("nf.stack");
        hashSet.add("nf.vmtype");
        hashSet.add("nf.zone");
        hashSet.add("process");
        DEFAULT_ATLAS_TAG_KEYS = Collections.unmodifiableSet(hashSet);
    }
}

