/*
 * Decompiled with CFR 0.152.
 */
package spectator-atlas.json.databind.deser.std;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import spectator-atlas.json.databind.JsonDeserializer;
import spectator-atlas.json.databind.deser.std.AtomicBooleanDeserializer;
import spectator-atlas.json.databind.deser.std.ByteBufferDeserializer;
import spectator-atlas.json.databind.deser.std.FromStringDeserializer;
import spectator-atlas.json.databind.deser.std.NullifyingDeserializer;
import spectator-atlas.json.databind.deser.std.StackTraceElementDeserializer;
import spectator-atlas.json.databind.deser.std.UUIDDeserializer;

public class JdkDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> rawType, String clsName) {
        if (_classNames.contains(clsName)) {
            FromStringDeserializer.Std d = FromStringDeserializer.findDeserializer(rawType);
            if (d != null) {
                return d;
            }
            if (rawType == UUID.class) {
                return new UUIDDeserializer();
            }
            if (rawType == StackTraceElement.class) {
                return new StackTraceElementDeserializer();
            }
            if (rawType == AtomicBoolean.class) {
                return new AtomicBooleanDeserializer();
            }
            if (rawType == ByteBuffer.class) {
                return new ByteBufferDeserializer();
            }
            if (rawType == Void.class) {
                return NullifyingDeserializer.instance;
            }
        }
        return null;
    }

    static {
        Class[] types;
        _classNames = new HashSet();
        for (Class clazz : types = new Class[]{UUID.class, AtomicBoolean.class, StackTraceElement.class, ByteBuffer.class, Void.class}) {
            _classNames.add(clazz.getName());
        }
        for (Class clazz : FromStringDeserializer.types()) {
            _classNames.add(clazz.getName());
        }
    }
}

