/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.gc;

import com.sun.management.GcInfo;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import spectator-agent.spectator.gc.GcType;

final class HelperFunctions {
    private static final Map<String, GcType> KNOWN_COLLECTOR_NAMES = HelperFunctions.knownCollectors();

    private HelperFunctions() {
    }

    private static Map<String, GcType> knownCollectors() {
        HashMap<String, GcType> m = new HashMap<String, GcType>();
        m.put("ConcurrentMarkSweep", GcType.OLD);
        m.put("Copy", GcType.YOUNG);
        m.put("G1 Old Generation", GcType.OLD);
        m.put("G1 Young Generation", GcType.YOUNG);
        m.put("MarkSweepCompact", GcType.OLD);
        m.put("PS MarkSweep", GcType.OLD);
        m.put("PS Scavenge", GcType.YOUNG);
        m.put("ParNew", GcType.YOUNG);
        return Collections.unmodifiableMap(m);
    }

    static GcType getGcType(String name) {
        GcType t = KNOWN_COLLECTOR_NAMES.get(name);
        return t == null ? GcType.UNKNOWN : t;
    }

    static boolean isOldGenPool(String name) {
        return name.endsWith("Old Gen") || name.endsWith("Tenured Gen");
    }

    static boolean isYoungGenPool(String name) {
        return name.endsWith("Eden Space");
    }

    static long getTotalUsage(Map<String, MemoryUsage> usages) {
        long sum = 0L;
        for (Map.Entry<String, MemoryUsage> e : usages.entrySet()) {
            sum += e.getValue().getUsed();
        }
        return sum;
    }

    static long getTotalMaxUsage(Map<String, MemoryUsage> usages) {
        long sum = 0L;
        for (Map.Entry<String, MemoryUsage> e : usages.entrySet()) {
            long max = e.getValue().getMax();
            if (max <= 0L) continue;
            sum += e.getValue().getMax();
        }
        return sum;
    }

    static long getPromotionSize(GcInfo info) {
        long totalBefore = HelperFunctions.getTotalUsage(info.getMemoryUsageBeforeGc());
        long totalAfter = HelperFunctions.getTotalUsage(info.getMemoryUsageAfterGc());
        return totalAfter - totalBefore;
    }
}

