/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.List;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.impl.StepDouble;

class AtlasMaxGauge
extends AtlasMeter
implements Gauge {
    private final StepDouble value;
    private final Id stat;

    AtlasMaxGauge(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(0.0, clock, step);
        this.stat = id.withTag(Statistic.max).withTags(id.tags()).withTag(DsType.gauge);
    }

    @Override
    void measure(List<Measurement> ms) {
        double v = this.value.poll();
        ms.add(new Measurement(this.stat, this.value.timestamp(), v));
    }

    @Override
    public void set(double v) {
        this.value.getCurrent().max(v);
        this.updateLastModTime();
    }

    @Override
    public double value() {
        return this.value.poll();
    }
}

