/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.List;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Gauge;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.impl.AtomicDouble;

class AtlasGauge
extends AtlasMeter
implements Gauge {
    private final AtomicDouble value = new AtomicDouble(0.0);
    private final Id stat;

    AtlasGauge(Id id, Clock clock, long ttl) {
        super(id, clock, ttl);
        this.stat = id.withTag(Statistic.gauge).withTags(id.tags()).withTag(DsType.gauge);
    }

    @Override
    void measure(List<Measurement> ms) {
        double v = this.value();
        if (Double.isFinite(v)) {
            ms.add(new Measurement(this.stat, this.clock.wallTime(), v));
        }
    }

    @Override
    public void set(double v) {
        this.value.set(v);
        this.updateLastModTime();
    }

    @Override
    public double value() {
        return this.value.get();
    }
}

