/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.atlas;

import java.util.List;
import spectator-agent.spectator.api.Clock;
import spectator-agent.spectator.api.Counter;
import spectator-agent.spectator.api.Id;
import spectator-agent.spectator.api.Measurement;
import spectator-agent.spectator.api.Statistic;
import spectator-agent.spectator.atlas.AtlasMeter;
import spectator-agent.spectator.atlas.DsType;
import spectator-agent.spectator.impl.StepDouble;

class AtlasCounter
extends AtlasMeter
implements Counter {
    private final StepDouble value;
    private final Id stat;

    AtlasCounter(Id id, Clock clock, long ttl, long step) {
        super(id, clock, ttl);
        this.value = new StepDouble(0.0, clock, step);
        this.stat = id.withTag(Statistic.count).withTags(id.tags()).withTag(DsType.rate);
    }

    @Override
    void measure(List<Measurement> ms) {
        double rate = this.value.pollAsRate();
        ms.add(new Measurement(this.stat, this.value.timestamp(), rate));
    }

    @Override
    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            this.value.getCurrent().addAndGet(amount);
            this.updateLastModTime();
        }
    }

    @Override
    public double actualCount() {
        return this.value.poll();
    }
}

