/*
 * Decompiled with CFR 0.152.
 */
package spectator-agent.spectator.jvm;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import spectator-agent.config.Config;
import spectator-agent.spectator.jvm.JmxMeasurementConfig;

final class JmxConfig {
    private final ObjectName query;
    private final List<JmxMeasurementConfig> measurements;

    static JmxConfig from(Config config) {
        try {
            ObjectName query = new ObjectName(config.getString("query"));
            ArrayList<JmxMeasurementConfig> ms = new ArrayList<JmxMeasurementConfig>();
            for (Config config2 : config.getConfigList("measurements")) {
                ms.add(JmxMeasurementConfig.from(config2));
            }
            return new JmxConfig(query, ms);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid mapping config", e);
        }
    }

    JmxConfig(ObjectName query, List<JmxMeasurementConfig> measurements) {
        this.query = query;
        this.measurements = measurements;
    }

    ObjectName getQuery() {
        return this.query;
    }

    List<JmxMeasurementConfig> getMeasurements() {
        return this.measurements;
    }
}

