/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.util;

import com.netflix.servo.jsr166e.ConcurrentHashMapV8;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ClockWithOffset;
import com.netflix.servo.util.Preconditions;
import com.netflix.servo.util.ThreadFactories;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ExpiringCache<K, V> {
    private final ConcurrentHashMapV8<K, Entry<V>> map;
    private final long expireAfterMs;
    private final ConcurrentHashMapV8.Fun<K, Entry<V>> entryGetter;
    private final Clock clock;
    private static final ScheduledExecutorService SERVICE = Executors.newSingleThreadScheduledExecutor(ThreadFactories.withName("expiringMap-%d"));

    public ExpiringCache(long expireAfterMs, ConcurrentHashMapV8.Fun<K, V> getter) {
        this(expireAfterMs, getter, TimeUnit.MINUTES.toMillis(1L), ClockWithOffset.INSTANCE);
    }

    public ExpiringCache(final long expireAfterMs, ConcurrentHashMapV8.Fun<K, V> getter, long expirationFreqMs, final Clock clock) {
        Preconditions.checkArgument(expireAfterMs > 0L, "expireAfterMs must be positive.");
        Preconditions.checkArgument(expirationFreqMs > 0L, "expirationFreqMs must be positive.");
        this.map = new ConcurrentHashMapV8();
        this.expireAfterMs = expireAfterMs;
        this.entryGetter = this.toEntry(getter);
        this.clock = clock;
        Runnable expirationJob = new Runnable(){

            @Override
            public void run() {
                long tooOld = clock.now() - expireAfterMs;
                for (Map.Entry entry : ExpiringCache.this.map.entrySet()) {
                    if (((Entry)entry.getValue()).accessTime >= tooOld) continue;
                    ExpiringCache.this.map.remove(entry.getKey(), entry.getValue());
                }
            }
        };
        SERVICE.scheduleWithFixedDelay(expirationJob, 1L, expirationFreqMs, TimeUnit.MILLISECONDS);
    }

    private ConcurrentHashMapV8.Fun<K, Entry<V>> toEntry(final ConcurrentHashMapV8.Fun<K, V> underlying) {
        return new ConcurrentHashMapV8.Fun<K, Entry<V>>(){

            public Entry<V> apply(K key) {
                return new Entry(underlying.apply(key), 0L, ExpiringCache.this.clock);
            }
        };
    }

    public V get(K key) {
        Entry entry = (Entry)this.map.computeIfAbsent(key, this.entryGetter);
        return (V)entry.getValue();
    }

    public List<V> values() {
        Collection values = this.map.values();
        ArrayList<Object> res = new ArrayList<Object>(values.size());
        for (Entry e : values) {
            res.add(e.value);
        }
        return Collections.unmodifiableList(res);
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return "ExpiringCache{map=" + this.map + ", expireAfterMs=" + this.expireAfterMs + '}';
    }

    private static final class Entry<V> {
        private volatile long accessTime;
        private final V value;
        private final Clock clock;

        private Entry(V value, long accessTime, Clock clock) {
            this.value = value;
            this.accessTime = accessTime;
            this.clock = clock;
        }

        private V getValue() {
            this.accessTime = this.clock.now();
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.accessTime == entry.accessTime && this.value.equals(entry.value);
        }

        public int hashCode() {
            int result = (int)(this.accessTime ^ this.accessTime >>> 32);
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "Entry{accessTime=" + this.accessTime + ", value=" + this.value + '}';
        }
    }
}

