/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pollers {
    public static final String POLLERS = System.getProperty("servo.pollers", "60000,10000");
    static final long[] DEFAULT_PERIODS = new long[]{60000L, 10000L};
    static final long[] POLLING_INTERVALS = Pollers.parse(POLLERS);
    private static final ImmutableList<Long> POLLING_INTERVALS_AS_LIST;
    public static final int NUM_POLLERS;

    private Pollers() {
    }

    public static List<Long> getPollingIntervals() {
        return POLLING_INTERVALS_AS_LIST;
    }

    private static String join(long[] a) {
        assert (a.length > 0);
        StringBuilder builder = new StringBuilder();
        builder.append(a[0]);
        for (int i = 1; i < a.length; ++i) {
            builder.append(',');
            builder.append(a[i]);
        }
        return builder.toString();
    }

    static long[] parse(String pollers) {
        String[] periods = pollers.split(",\\s*");
        long[] result = new long[periods.length];
        boolean errors = false;
        Logger logger = LoggerFactory.getLogger(Pollers.class);
        for (int i = 0; i < periods.length; ++i) {
            String period = periods[i];
            try {
                result[i] = Long.parseLong(period);
                if (result[i] > 0L) continue;
                logger.error("Invalid polling interval: {} must be positive.", (Object)period);
                errors = true;
                continue;
            }
            catch (NumberFormatException e) {
                logger.error("Cannot parse '{}' as a long: {}", (Object)period, (Object)e.getMessage());
                errors = true;
            }
        }
        if (errors || periods.length == 0) {
            logger.info("Using a default configuration for poller intervals: {}", (Object)Pollers.join(DEFAULT_PERIODS));
            return DEFAULT_PERIODS;
        }
        return result;
    }

    static {
        NUM_POLLERS = POLLING_INTERVALS.length;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (long pollingInterval : POLLING_INTERVALS) {
            builder.add((Object)pollingInterval);
        }
        POLLING_INTERVALS_AS_LIST = builder.build();
    }
}

