/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.Metric;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.publish.MetricObserver;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.util.Clock;
import com.netflix.servo.util.ClockWithOffset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NormalizationTransform
implements MetricObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(NormalizationTransform.class);
    private static final String DEFAULT_DSTYPE = DataSourceType.RATE.name();
    @VisibleForTesting
    static final Counter HEARTBEAT_EXCEEDED = NormalizationTransform.newCounter("servo.norm.heartbeatExceeded");
    private final MetricObserver observer;
    private final long heartbeatMillis;
    private final long stepMillis;
    private final Map<MonitorConfig, NormalizedValue> cache;
    private static final long NO_PREVIOUS_UPDATE = -1L;

    static Counter newCounter(String name) {
        Counter c = Monitors.newCounter(name);
        DefaultMonitorRegistry.getInstance().register(c);
        return c;
    }

    @Deprecated
    public NormalizationTransform(MetricObserver observer, long step, long heartbeat) {
        this(observer, step, heartbeat, TimeUnit.MILLISECONDS, ClockWithOffset.INSTANCE);
    }

    @Deprecated
    public NormalizationTransform(MetricObserver observer, long step, long heartbeat, Clock clock) {
        this(observer, step, heartbeat, TimeUnit.MILLISECONDS, ClockWithOffset.INSTANCE);
    }

    public NormalizationTransform(MetricObserver observer, long step, long heartbeat, TimeUnit unit) {
        this(observer, step, heartbeat, unit, ClockWithOffset.INSTANCE);
    }

    public NormalizationTransform(MetricObserver observer, long step, long heartbeat, TimeUnit unit, final Clock clock) {
        this.observer = (MetricObserver)Preconditions.checkNotNull((Object)observer);
        Preconditions.checkArgument((step > 0L ? 1 : 0) != 0, (Object)"step must be positive");
        this.stepMillis = unit.toMillis(step);
        Preconditions.checkArgument((heartbeat > 0L ? 1 : 0) != 0, (Object)"heartbeat must be positive");
        this.heartbeatMillis = unit.toMillis(heartbeat);
        this.cache = new LinkedHashMap<MonitorConfig, NormalizedValue>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<MonitorConfig, NormalizedValue> eldest) {
                boolean expired;
                long lastMod = eldest.getValue().lastUpdateTime;
                if (lastMod < 0L) {
                    return false;
                }
                long now = clock.now();
                boolean bl = expired = now - lastMod > NormalizationTransform.this.heartbeatMillis;
                if (expired) {
                    HEARTBEAT_EXCEEDED.increment();
                    LOGGER.debug("heartbeat interval exceeded, expiring {}", (Object)eldest.getKey());
                }
                return expired;
            }
        };
    }

    private static String getDataSourceType(Metric m) {
        TagList tags = m.getConfig().getTags();
        String value = tags.getValue(DataSourceType.KEY);
        if (value != null) {
            return value;
        }
        return DEFAULT_DSTYPE;
    }

    private static boolean isGauge(String dsType) {
        return dsType.equals(DataSourceType.GAUGE.name());
    }

    private static boolean isRate(String dsType) {
        return dsType.equals(DataSourceType.RATE.name());
    }

    private static boolean isInformational(String dsType) {
        return dsType.equals(DataSourceType.INFORMATIONAL.name());
    }

    private MonitorConfig toGaugeConfig(MonitorConfig config) {
        return config.withAdditionalTag(DataSourceType.GAUGE);
    }

    private Metric normalize(Metric m, long stepBoundary) {
        NormalizedValue normalizedValue = this.cache.get(m.getConfig());
        if (normalizedValue == null) {
            normalizedValue = new NormalizedValue();
            this.cache.put(m.getConfig(), normalizedValue);
        }
        double value = normalizedValue.updateAndGet(m.getTimestamp(), m.getNumberValue().doubleValue());
        return new Metric(this.toGaugeConfig(m.getConfig()), stepBoundary, value);
    }

    @Override
    public void update(List<Metric> metrics) {
        Preconditions.checkNotNull(metrics);
        ArrayList newMetrics = Lists.newArrayListWithCapacity((int)metrics.size());
        for (Metric m : metrics) {
            long offset = m.getTimestamp() % this.stepMillis;
            long stepBoundary = m.getTimestamp() - offset;
            String dsType = NormalizationTransform.getDataSourceType(m);
            if (NormalizationTransform.isGauge(dsType)) {
                Metric atStepBoundary = new Metric(m.getConfig(), stepBoundary, m.getValue());
                newMetrics.add(atStepBoundary);
                continue;
            }
            if (NormalizationTransform.isRate(dsType)) {
                Metric normalized = this.normalize(m, stepBoundary);
                if (normalized == null) continue;
                newMetrics.add(normalized);
                continue;
            }
            if (NormalizationTransform.isInformational(dsType)) continue;
            LOGGER.warn("NormalizationTransform should get only GAUGE and RATE metrics. Please use CounterToRateMetricTransform. " + m.getConfig());
        }
        this.observer.update(newMetrics);
    }

    @Override
    public String getName() {
        return this.observer.getName();
    }

    private class NormalizedValue {
        private long lastUpdateTime = -1L;
        private double lastValue = 0.0;

        private NormalizedValue() {
        }

        private double weightedValue(long offset, double value) {
            double weight = (double)offset / (double)NormalizationTransform.this.stepMillis;
            return value * weight;
        }

        double updateAndGet(long timestamp, double value) {
            double result = Double.NaN;
            if (timestamp > this.lastUpdateTime) {
                long offset;
                long stepBoundary;
                if (this.lastUpdateTime > 0L && timestamp - this.lastUpdateTime > NormalizationTransform.this.heartbeatMillis) {
                    this.lastUpdateTime = -1L;
                    this.lastValue = 0.0;
                }
                if (this.lastUpdateTime < (stepBoundary = timestamp - (offset = timestamp % NormalizationTransform.this.stepMillis))) {
                    if (this.lastUpdateTime != -1L) {
                        long intervalOffset = this.lastUpdateTime % NormalizationTransform.this.stepMillis;
                        this.lastValue += this.weightedValue(NormalizationTransform.this.stepMillis - intervalOffset, value);
                        result = this.lastValue;
                    } else {
                        result = offset == 0L ? value : this.weightedValue(NormalizationTransform.this.stepMillis - offset, value);
                    }
                    this.lastValue = this.weightedValue(offset, value);
                } else {
                    long intervalOffset = timestamp - this.lastUpdateTime;
                    this.lastValue += this.weightedValue(intervalOffset, value);
                    result = this.lastValue;
                }
            }
            this.lastUpdateTime = timestamp;
            return result;
        }
    }
}

