/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.annotations.Monitor;
import java.util.concurrent.TimeUnit;

class MonitoredCache {
    private static final int CACHE_TIME = 10;
    private final Supplier<CacheStats> statsSupplier;

    MonitoredCache(final Cache<?, ?> cache) {
        Supplier<CacheStats> supplier = new Supplier<CacheStats>(){

            public CacheStats get() {
                return cache.stats();
            }
        };
        this.statsSupplier = Suppliers.memoizeWithExpiration((Supplier)supplier, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Monitor(name="averageLoadPenalty", type=DataSourceType.GAUGE)
    double averageLoadPenalty() {
        return ((CacheStats)this.statsSupplier.get()).averageLoadPenalty();
    }

    @Monitor(name="evictionCount", type=DataSourceType.COUNTER)
    long evictionCount() {
        return ((CacheStats)this.statsSupplier.get()).evictionCount();
    }

    @Monitor(name="hitCount", type=DataSourceType.COUNTER)
    long hitCount() {
        return ((CacheStats)this.statsSupplier.get()).hitCount();
    }

    @Monitor(name="loadCount", type=DataSourceType.COUNTER)
    long loadCount() {
        return ((CacheStats)this.statsSupplier.get()).loadCount();
    }

    @Monitor(name="loadExceptionCount", type=DataSourceType.COUNTER)
    long loadExceptionCount() {
        return ((CacheStats)this.statsSupplier.get()).loadExceptionCount();
    }

    @Monitor(name="loadSuccessCount", type=DataSourceType.COUNTER)
    long loadSuccessCount() {
        return ((CacheStats)this.statsSupplier.get()).loadSuccessCount();
    }

    @Monitor(name="missCount", type=DataSourceType.COUNTER)
    long missCount() {
        return ((CacheStats)this.statsSupplier.get()).missCount();
    }

    @Monitor(name="requestCount", type=DataSourceType.COUNTER)
    long requestCount() {
        return ((CacheStats)this.statsSupplier.get()).requestCount();
    }

    @Monitor(name="totalLoadTime", type=DataSourceType.COUNTER)
    long totalLoadTime() {
        return ((CacheStats)this.statsSupplier.get()).totalLoadTime();
    }
}

